/***************************************************************************
                          cutt.cpp  -  description
                          Cuts a big file in a series of smaller ones
                             -------------------                                         
    begin                : 02/20/2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cutt.h"

#include <kdebug.h>
#include <qfileinfo.h>

cuttFichier::cuttFichier() {
}

cuttFichier::~cuttFichier() {
}

void cuttFichier::Cut(const unsigned int Nbr, const long T, const long Tb, QString target)
{
  long len;
  int i;
  QString ext;
  ext.sprintf(".%02d", Nbr);
  target=target+ext;
  QFile output(target);
  output.open(IO_WriteOnly);
  
  for (i = 1; i <= T; i++)
  {
    len=input.readBlock(buffer, buffersize);
    output.writeBlock(buffer, len);
  }
  len=input.readBlock(buffer, Tb);
  output.writeBlock(buffer, len);
  
  output.close();
}

int cuttFichier::uncut(QString splitArchiveName, QString directory)
{
  QFile output;
  long sizeFullBlocks, sizePartialBlock;
  long size;
  long len;
  int i, j;
  QString ext;
  QString target;
  
  if(!directory.endsWith("/"))
    directory+="/";
  target=directory+QFileInfo(splitArchiveName).baseName(true);
  output.setName(target);
  if(!output.open(IO_WriteOnly))
    return CUTT_ERROR;
  
  for(i=1;i<99;i++)
  {
    input.close();
    ext.sprintf(".%02d", i);
    input.setName(target+ext);
    kdDebug()<<QString("Reading %1").arg(target+ext)<<endl;
    if(!input.open(IO_ReadOnly))
      break;
    
    size=input.size();
    sizeFullBlocks = size / buffersize;
    sizePartialBlock = size % buffersize;
    
    for (j = 1; j <= sizeFullBlocks; j++)
    {
      len = input.readBlock(buffer, buffersize);
      output.writeBlock(buffer, len);
    }
    len = input.readBlock(buffer, sizePartialBlock);
    output.writeBlock(buffer, len);
  }
  
  output.close();
  input.close();
  
  return CUTT_OK;
}

/*Start to cutt or uncutt an archive
	operation==0 means cutt
	operation ==1 means uncutt
*/
int cuttFichier::Begin(QString archiveName, int operation, QString directory, int blocksize)
{
  int error;
  input.setName(archiveName);
  if(!input.open(IO_ReadOnly))
    error=CUTT_ERROR;
  else if(operation==SPLIT)
  {
    QString targetname=directory+QFileInfo(archiveName).fileName();
    long archivesize;
    long sizeFullBlocks, sizePartialBlock;
    int nbBlocks;
    int i;
    
    archivesize=input.size();
    if(archivesize < blocksize)//Nothing to do
      error=CUTT_ERROR;
    else
    {
      nbBlocks = archivesize / blocksize;
      if (nbBlocks > 99)
        error=CUTT_ERROR;
      else
      {
        sizeFullBlocks = blocksize / buffersize;
        sizePartialBlock = blocksize % buffersize;
        
        for (i = 1; i<= nbBlocks; i++)
          Cut(i, sizeFullBlocks, sizePartialBlock, targetname);
    
        sizePartialBlock = archivesize % buffersize;
    
        if (sizePartialBlock != 0)
          Cut(nbBlocks+1, sizePartialBlock / buffersize, sizePartialBlock % buffersize, targetname);
    
        input.close();
        error=CUTT_OK;
      }
    }
  }
  else
    error=uncut(archiveName, directory);
  
  return error;
}
