/***************************************************************************
                          crar.h  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CRAR_H
#define CRAR_H

#include <carchive.h>
#include "mykrar.h"

/**This class will manage the .rar archives
  *@author Eric Coquelle
  */

class CRar : public CArchive  {
Q_OBJECT
public: 
	CRar();
	~CRar();
  /** this method will launch the right compressor
		to list the file contents
		It will then launch the right method to display
		the content in the listview */
  void displayArchiveContent();

	/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
	*@extractall = 9: extract to karchiveur's temp directory (for viewing)
	*@extractall = 1: extract all selected files
	*/
	void extractArchive(QString & extractpath, int extractall, QString & filetoextract);
	/** delete @param filestodelete from current archive */
	void removeFilesFromArchive (QStringList filestodelete);
	/** Create a rar archive
	@param  nameofarchive: the name of the zip archive
	@param param: list of files to add
	@param relativepath: include only filenames, without their path */
 void createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath);
	/** Add some files to the archive
		@param filestoadd : list of files to add
		@param removeoriginalfiles : remove or not those files from disk
		@param action : 0=mode append and replace files, 1=mode update files
		@param relativepath : if !NULL, include only filenames, without their base path */
 void addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath=NULL);
 /*Returns true as zip archives can be listed by KIO*/
 bool supportDisplayByDirs(){return true;};
 /** Returns true if archive type supports passwords */
  bool supportPassword();
  /**Returns true if current archive can be repaired*/
  bool canRepairArchive();
  /**Launches the repair process*/
  void repairCurrentArchive();

protected: // Protected methods
  /** display in a listview the content of the current
		* rar archive. This method examines the stdout of
		* unarj to sort useful infos for the listview */
  void displayRarArchiveContent( FILE* flot );
  /* Overloaded method */
	void displayRarArchiveContent( const char* line);
	
protected slots:
  void endProcess(KProcess*);
  void endReadProcess(KProcess*);
  void haveSdtOut(KProcess *prpc, char *buffer, int length);
  /** we recive some informations through the standard
          * output of the process */
  void haveSdtOutExtract(KProcess *prpc, char *buffer, int length);
  void haveSdtErrExtract(KProcess *prpc, char *buffer, int length);
  void haveStdErr(KProcess *, char *buffer, int length);

protected:
	/* RAR output isn't very simple to handle => store the output in 2 strings
		and then process them */
	int flag;
	bool finished;
 bool mustreadoncemore;
	QCString m_line1;
  QCString m_buffer;
  bool passwordrequired;
  int processingRarHeader;
  enum headerStatus {BEGIN_HEADER, BEGIN_COMMENT, END_COMMENT, HEADER_PROCESSED};
  MyKRar* rarfile;

};

#endif
