/***************************************************************************
                          cfileinfo.cpp  -  description
                             -------------------
    begin                : sam sep 27 2003
    copyright            : (C) 2003 by eric
    email                : eric@portable
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cfileinfo.h"

CFileInfo::CFileInfo():QFileInfo(){
}

CFileInfo::CFileInfo(QString s):QFileInfo(s){
}

CFileInfo::~CFileInfo(){
}

/** return the proper filename without its extension */
QString CFileInfo::baseName(bool complete){
  QString ext=extension();

  if(ext.isEmpty()||complete)
    return QFileInfo::extension(complete);
  else
    return fileName().left(fileName().length()-ext.length()-1);
}

/** return the proper extension */
QString CFileInfo::extension(bool complete){
  QString ext;

  if(!complete)
    return QFileInfo::extension(complete);
    
  ext=QFileInfo::extension(false);
  if(fileName().mid(fileName().length()-ext.length()-5,4)==".tar")
    ext="tar."+ext;

  return ext;
}
