/***************************************************************************
                          cchoixfichier.h  -  description                              
                             -------------------                                         
    begin                : Thu Jun 3 1999                                           
    copyright            : (C) 1999 by Eric Coquelle                         
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef CCHOIXFICHIER_H
#define CCHOIXFICHIER_H

#include <qwidget.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <qdir.h>
#include "resource.h"

/** The CArchiveChoice class provides methods to open and sort archives
	* It determines the compressor to use, the options for reading,
	* extracting, deleting files
	*/
class CArchiveChoice : public QWidget
{
	Q_OBJECT
public: 
  CArchiveChoice(QWidget *parent=0, const char *name=0);
  ~CArchiveChoice();
  
  /* Open a dialog and return the file's name */
  QString openArchive();
  /** Finds which compressor is required to read currentarchive 
  * returns UNKNOWN if format is not supported, 0 otherwise */
  int findKindOfCompressor();
  /* Return the option for compressing files*/
  QString getCompresseur();
  /* return the option for uncompressing files */
  QString getUncompressor();
  /* return the option for reading archive */
  QString getReader();
  /* return the archive's name (with full path) */
  QString getArchiveName();
  /* return the compressor's name */
  QString getProgrCompresseur();
  /* Get any special option for the compressor */
  QString getOptionSupp();
  void initialise();
  /* return the option for adding files to an archive */
  QString getConcateneur();
  /* Define the archive's name */
  void setArchiveName(QString);
  /** Set the acess path when opening an archive */
  void setFullPath( QString path);
  /** return the directory's path of the opened file */
  QString getAccessPath();
  /** Define the default path when opening a file
      0: Last dir
      1: home dir
      2: shell's one */
  void setFullPath(QString path, int optionOpening);
  /** returns the exact compressor type */
  int getKindOfCompressor();
  /** Define the default path when opening a file
    * 0: Last dir
    * 1: home dir
          * 2: shell's one */
  void setOptionOpening(int optionOuverture);
  /** return the directory of the current archive */
  QString getCurrentArchiveDirectory();
  /** We store somewhere an oldpath variable,
    * used to know what is the last open dir */
  void setForInitPreviousPath( QString path );
  /** Return true if the compressor that'll be used is installed on disk */
  bool isCurrentCompressorAvaible();
  /** check which compressors are available */
  static int getInstalledCompressors();
	
 private:
	KFileDialog *dlgbox;
	/* The last open directory*/
	QDir m_path, m_previouspath;
	/* The filtere for KFileDialog*/
	QString filter;
	QString currentarchive;
	/*The NAME of the compressor to use*/	
	QString nameofCompressor;
	/*The options like -vlf for COMPRESSING archive*/
	QString compresseur;
	/*The option for EXTRACTING files*/
	QString uncompressor;
	/*The options like -vlf for READING archive*/	
	QString reader;
	/*The options for ADDING files to archive*/
	QString compressandconcatenate;
	/*Some SPECIAL options*/
	QString optionSupp;
	/* contains the type of the compressor used*/
	int kindofCompressor;
	/* If 0, open dir=last dir
	   If 1, open dir=homedir
	   If 2, open dir=shell's one
	*/
	int kindofLastDirectory;
	/*Tells wether the compressor is avaible*/
	bool compressoravaible;
	static int installedcompressors;
};

#endif
