/***************************************************************************
                          czip.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "car.h"

#include <kdebug.h>
#include <kmessagebox.h> 
#include <qdir.h>

CAr::CAr(){
  CArchive();
  
  connect(&processread,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOut(KProcess*,char*,int)));
  connect(&processread,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));
  connect(&processextract,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOutExtract(KProcess*,char*,int)));
  connect(&processextract,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));
  connect(&processextract, SIGNAL(receivedStderr(KProcess *, char *, int)),this, SLOT(haveSdtErrExtract(KProcess*,char*,int)));
  connect(&processadd,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(haveSdtOutExtract(KProcess*,char*,int)));
  connect(&processadd,SIGNAL(processExited (KProcess*)),this,SLOT(endProcess(KProcess*)));

  list->setColumnText(4, i18n("Owner"));
  list->setColumnText(5, i18n("Permissions"));
}

CAr::~CAr(){
}

/** this method will launch the right compressor
	to list the file contents
	It will then launch the right method to display
	the content in the listview */
void CAr::displayArchiveContent(){

  initializeReadingArchive();
  	
    processread << "ar";
  	processread << "-tv" << archiveName;

    m_buffer[0]='\0';
    headerremoved=true;
    finished=false;
    processread.start(KProcess::NotifyOnExit, KProcess::AllOutput);
}
/** display in a listview the content of the current
zip archive. This method examines the stdout of
unarj to sort useful infos for the listview */
void CAr::displayArArchiveContent( const char* line){
  CListViewItem* elementListe=NULL;
  QString ratio;
    char permission[30];
    char owner[256];
    char size[30];
    QString date;
    char year[5];
    char month[5];
    char day[3];
    char hour[9];
    char sname[5000];
    QString path;
    QString name;
    QString message;
    QString y, m, d;
    int i;

kdDebug()<<QString("Read deb:%1").arg(line)<<endl;
    sscanf(line, "%[-drwxstl] %[0-9a-zA-Z./_] %[0-9] %[a-zA-Z] %[0-9] %[0-9:-] %[0-9] %[^\n]",permission, owner, size, month, day, hour, year, sname );
kdDebug()<<QString("Identified %1, %2, %3, %4, %5, %6, %7, %8").arg(permission).arg(owner).arg(size).arg(month).arg(day).arg(hour).arg(year).arg(sname)<<endl;
  
  name=sname;
  i=name.findRev('/');
  if(i!=-1)
  {
    path=name.left(i+1);
    name=name.remove(0,i+1);
    if(name=="")name="..";
  }
  else
    path="";

  y=year;
  m=month;
  m.truncate(2);
  d=day;
  d.truncate(2);

  
  elementListe=new CListViewItem(list,name,size,hour,getLocalizedDate(QDate(y.toInt(),m.toInt(),d.toInt())), owner,permission,path);

  setIcon(name, "", elementListe);
  elementListe->widthChanged();
}

/** we recive some informations through the standard
output of the process */
void CAr::haveSdtOut(KProcess *, char *buffer, int length){
	//Has user canceled current action ?
	if(stopreadprocess)
		return;

	// This section is here only for testing. It has been taken from ark:
	//1997-1999: Rob Palmbos palm9744@kettering.edu
	//2000: Corel Corporation (author: Emily Ezust, emilye@corel.com)
	//and adapted to karchiveur
//	int passage;
  char c = buffer[length];
  buffer[length] = '\0';

  char line[1024] = "";
  char *tmpl = line;
  char *tmpb;


  //We copy m_buffer to tmpl
  for( tmpb = m_buffer; *tmpb != '\0'; tmpl++, tmpb++ )
    *tmpl = *tmpb;

  //We copy the fisrt string of buffer (till \n) to tmpl
  for( tmpb = buffer; *tmpb != '\n'; tmpl++, tmpb++ )
    *tmpl = *tmpb;

  tmpb++;
  *tmpl = '\0';

  if( *tmpb == '\0' )
    m_buffer[0]='\0';

  if( !strstr( line, "----" ) )
	{
  	if( headerremoved && !finished )
  	{
//	if((strncmp(line,"Archive: ",9)!=0)&&(strncmp(line," Length   Method",16)!=0))
			displayArArchiveContent( line );
		}
	}
  else if(!headerremoved)
    headerremoved = true;
  else
    finished = true;

  bool stop = (*tmpb == '\0');

  while( !stop && !finished)
  {
      tmpl = line; *tmpl = '\0';

      for(; (*tmpb!='\n') && (*tmpb!='\0'); tmpl++, tmpb++)
				*tmpl = *tmpb;

      if( *tmpb == '\n' )
			{
			  *tmpl = '\n';
			  tmpl++;
			  *tmpl = '\0';
			  tmpb++;

      if( !strstr( line, "----" ) )
    	{
      	if( headerremoved && !finished )
      	{
    //	if((strncmp(line,"Archive: ",9)!=0)&&(strncmp(line," Length   Method",16)!=0))
    			displayArArchiveContent( line );
    		}
    	}
      else if(!headerremoved)
        headerremoved = true;
      else
        finished = true;
/*	  	if((passage<1)&&(strncmp(line,"--------",8)!=0)&&(strncmp(line," Length   Method",16)!=0))
  			displayArArchiveContent( line );
  		else
  			passage++;*/
			}
      else if (*tmpb == '\0' )
			{
	  		*tmpl = '\0';
			  strcpy( m_buffer, line );
	  		stop = true;
			}
    }
  buffer[length] = c;
}

/** we recive some informations through the standard
	* output of the process */
void CAr::haveSdtOutExtract(KProcess *, char *, int ){
	counter++;
	if(counter%2==0)
		progressbar->setProgress(progressbar->progress()+ 1 );

}

/** The current process ended */
void CAr::endProcess(KProcess*){
  kdDebug()<<("Process ENDED\n");

	emit(archiveReadEnded());
}

/** Upon the kind of archive, choose the right
	*uncompressor and extract all or some files
	*@toutextraire = 9: extract to karchiveur's temp directory (for viewing)
	*@toutextraire = 1: extract all selected files
	*/
void CAr::extractArchive(QString & extractpath, int extractall, QString &filetoextract){
  QStringList listsubdir;
  QDir::setCurrent(extractpath);
  
  errors.clear();
  counter=0;
  progressbar->reset();

  processextract.clearArguments();
  processextract << "ar";
  processextract << "-xo";

  processextract << archiveName;
  if((extractall!=EXTRACTONE)&&(extractall!=EXTRACTONE_AND_BLOCK)&&(!checkFiles(extractpath, extractall)))
  {
    endProcess(NULL);
    return;
  }
  else if(extractall==EXTRACTONE_AND_BLOCK)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::Block)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall==EXTRACTONE)
  {
    //We want to view (and so extract) only one file. So we just add this file to the tar or unzip
    //command. For gzip and bzip2 files, in any case, we extract one and only one file, so I put
    //it apart
    processextract << filetoextract;
    if(processextract.start(KProcess::NotifyOnExit)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  else if(extractall!=EXTRACTONE_AND_BLOCK)
  {
          //We extract through the Stdout to have a progress indicator
    if(processextract.start(KProcess::NotifyOnExit,KProcess::AllOutput)==FALSE)
      kdDebug()<<("\n*PB PROCESS*\n");
  }
  counter=0;
}

/** delete @param filestodelete from current archive */
void CAr::removeFilesFromArchive( QStringList filestodelete ){
 	processread.clearArguments();
 	processread << "ar" << "-d";
 	processread << archiveName;
  for (QStringList::Iterator f = filestodelete.begin(); f!=filestodelete.end(); ++f )
 	{
   	  processread << *f;
	}
  processread.start(KProcess::Block);
}

/** Add some files to the archive
@param filestoadd : list of files to add
@param removeoriginalfiles : remove or not those files from disk
@param action : 0=mode append and replace files, 1=mode update files
@param relativepath : if !NULL, include only filenames, without their base path */
void CAr::addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath){
	QString s;
 kdDebug()<<QString("CAr::addFilesToArchive %1, RelativePath=%2 comprrate %3").arg(archiveName).arg(relativepath).arg(compressrate)<<endl;
	if(relativepath!=NULL)
		QDir::setCurrent(relativepath);

	processadd.clearArguments();
	processadd << "ar";

    switch(action)
    {
            case 0:
                    //Mode add&replace
                    processadd << "-r";
                    break;
            case 1:
                    //Mode update
                    processadd << "-ru";
                    break;
    }
    
    processadd << archiveName;
    for (QStringList::Iterator f = filestoadd.begin(); f!=filestoadd.end(); ++f )
    {
      s=*f;
      if(s.endsWith("/") )
        s.truncate(s.length()-1);
      if(s.startsWith("file:"))
        s.remove(0,5);
    kdDebug()<<QString("Appending %1 to Ar file").arg(s)<<endl;
    processadd << s;
    }
    processadd.start(KProcess::NotifyOnExit);
}

/** Create a zip archive
@param  nameofarchive: the name of the zip archive
@param param: list of files to add
@param relativepath: include only filenames, without their path */
void CAr::createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath) {
	QString str;

	archiveName=nameofarchive;
	kdDebug()<<QString("BeginCreationAr*%1*%2*").arg(nameofarchive).arg(relativepath)<<endl;
	addFilesToArchive(filestoadd, false, 0,relativepath);
}

#include "car.moc"
