/***************************************************************************
                          canimation  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <klocale.h>
#include <qpainter.h>
#include <qlayout.h>

#include "canimation.h"


CAnimation::CAnimation( QWidget * parent, const char * name, bool modal, WFlags f ) : QDialog(parent, name, modal, f)
{
   QGridLayout *layout = new QGridLayout(this, 1, 2);
   cancelbutton = new QPushButton(this);
   cancelbutton->setText(i18n("Cancel"));
   connect(cancelbutton, SIGNAL(clicked()), this, SLOT(slotCancel()));
   layout->addWidget(cancelbutton, 1, 2);
   
   setCaption(i18n("KArchiver is busy"));
   pix1=UserIcon("karchiver_fileopen");
   pix2=UserIcon("karchiver_filepacked");
   pix3=UserIcon("karchiver_fileprocessed");
   
   bg.resize(pix3.size());
   bg.fill(backgroundColor());
   
   layout->setRowSpacing(0, pix1.height());
   
   resize(5*pix1.width(), pix1.height());
   borderl=pix1.width();
   borderr=width()-pix2.width();
   
   animy=(pix1.height()-pix3.height())/2;//center moving pixmap
   connect( &timerwait, SIGNAL(timeout()), this, SLOT(launchAnimation()) );
   connect( &timer, SIGNAL(timeout()), this, SLOT(performAnimation()) );
}

CAnimation::~CAnimation()
{
}

/**Paints the top right and top left pixmaps*/
void CAnimation::paintEvent ( QPaintEvent* )
{
   QPainter p;
   p.begin(this);
   p.drawPixmap(0, height()-pix1.height(), pix1);
   p.drawPixmap(width()-pix2.width(), 0, pix2);
   p.end();
}

/**Don't display display this dialog box if reading/extraction is very fast*/
void CAnimation::startAnimation()
{
   timerwait.start( 1000, true );
}

/**Launches the animation*/
void CAnimation::launchAnimation()
{
   show();
   repaint();
   animx=borderl+1;
   animsize=pix3.width();
   timer.start( 20, false );
}


void CAnimation::stopAnimation()
{
   timerwait.stop();
   timer.stop();
   hide();
}

/**Moves pixmap pix3 from left to right*/
void CAnimation::performAnimation()
{
   bitBlt(this, animx, animy, &bg, 0, 0, animsize, pix3.width());
   animx+=1;
   if(animx<borderl+pix3.width())
   {
      animsize=animx-borderl;//goes from 0 to pix3.width() 
      bitBlt(this, animx, animy+pix3.height()-animsize, &pix3, pix3.width()-animsize, 0, animsize, animsize);
   }
   else if(animx>borderr-pix3.width())
   {
      if(animx>borderr)
      {
         animx=borderl;
         animsize=pix3.width();
      }
      else
      {
         animsize=borderr-animx;
         bitBlt(this, animx, animy, &pix3, 0, 0, animsize, pix3.width());
      }
   }
   else
      bitBlt(this, animx, animy, &pix3);
}

void CAnimation::slotCancel()
{
   stopAnimation();
   hide();
   emit animationCancelled();
}

#include "canimation.moc"
