/***************************************************************************
                          czip.h  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _C7Z_H_
#define _C7Z_H_

#include "carchive.h"

/**This class will manage the 7z archives
  *@author Eric Coquelle
  */

class C7z : public CArchive  {
Q_OBJECT
public: 
	C7z();
	~C7z();
  /** this method will launch the right compressor
		* to list the file contents
		* It will then launch the right method to display
		* the content in the listview */
  void displayArchiveContent();
	/** Upon the kind of archive, choose the right
		* uncompressor and extract all or some files
		* @extractall = 9: extract to karchiveur's temp directory (for viewing)
		* @extractall = 1: extract all selected files
	*/
	void extractArchive(QString & extractpath, int extractall, QString & filetoextract);
  /** delete @param filestodelete from current archive */
  void removeFilesFromArchive( QStringList filestodelete );
  /** Add some files to the archive
  @param filestoadd : list of files to add
  @param removeoriginalfiles : remove or not those files from disk
  @param action : 0=mode append and replace files, 1=mode update files
  @param relativepath : if !NULL, include only filenames, without their base path */
  void addFilesToArchive( QStringList filestoadd, bool removeoriginalfiles, int action, QString relativepath=NULL);
  /** Create a zip archive
  @param  nameofarchive: the name of the targz archive
  @param param: list of files to add
  @param relativepath: include only filenames, without their path */
  void createArchive(QString nameofarchive, QStringList filestoadd, QString relativepath=NULL);
  /** Returns true if archive type supports passwords */
  bool supportPassword();
  /**Check integrity of current archive*/
  void testCurrentArchiveIntegrity();
  
protected: // Protected methods
  /** display in a listview the content of the current
    * zip archive. This method examines the stdout of
    * unarj to sort useful infos for the listview */
  void display7zArchiveContent( const char* );
  bool checkFiles7z(QString extractpath, int extractall);
  void extractOneFile();

protected slots:
  void endProcess(KProcess*);
  void haveSdtOut(KProcess *prpc, char *buffer, int length);
  /** we recive some informations through the standard
    * output of the process */
  void haveSdtOutExtract(KProcess *prpc, char *buffer, int length);
  void haveSdtErrExtract(KProcess *prpc, char *buffer, int length);
  void reconstructpath(KProcess*);

private:
  bool headerremoved;
  bool finished;
  QString tmpdir;
  QStringList listfilestoextract;
  QString extractdirectory;
  int extractallfiles;
  CProcessus processextract7z;
};

#endif
