#ifndef __PREF_H__
#define __PREF_H__

#include <qobject.h>
#include <qdict.h>
#include <qstring.h>
#include <qstringlist.h>

#include <kdebug.h>

class KConfig;
class desktopInfo;
class configDlg;

typedef struct {
    QString name;
    QString file;
    int w;
    int h;
    int numofanim;
    Qt::Orientation orientation;
} fishInfoStr;

class fishInfo
{
public:
    fishInfo(QString name, QString file, int w, int h, int numofanim, Qt::Orientation orie)
            : m_name(name), m_file(file), m_w(w)
            , m_h(h), m_numofanim(numofanim), m_orie(orie)
    { };
    ~fishInfo()
    { kdDebug(1210) << "Delete fishInfo!" << m_name << endl; };
    
private:
    QString m_name, m_file;
    int m_w, m_h, m_numofanim;
    Qt::Orientation m_orie;
};

class kfishPref : public QObject
{
    Q_OBJECT
public:
    enum fishAnimations { None = 0, Mouse, Timer };

    static kfishPref *prefs();
    
    void load();
    void write();
    
    int getFishNumber() const { return m_fishNumber; };
    int getBubblesNumber() const { return m_numBubble; };
    int getWidth() const { return m_widthSpace; };
    int getFishScale() const { return m_fishScale; };
    bool getFishSel() const { return m_fishSel; };
    bool getFishRan() const { return m_fishRan; };
    QDict<QString> getFishSelected() { return m_fishSelNum; };
    fishInfoStr* getFishInfo();
    
    int getPanelHeight() const { return m_height; };
    int getPanelWidth() const { return m_width; };
    Orientation getOrientation() const { return m_panelOrientation; };

    void setFishNumber(int num) { m_fishNumber = num; };
    void setBubbleNumber(int num) { m_numBubble = num; };
    void setWidth(int width ) { m_widthSpace = width; };
    void setFishScale(int scale) { m_fishScale = scale; };
    void setFishSel(bool sel) { m_fishSel = sel; };
    void setFishRan(bool ran) { m_fishRan = ran; };
    void setFishSelected(QDict<QString> fishSel) 
        {
            m_fishSelNum. clear();
            m_fishSelNum = fishSel;
        };
    
    void setPanelWidth( int w ) { m_width = w; };
    void setPanelHeight( int h ) { if (h > 1) m_height = h; };
    void setOrientation( Orientation type ) { m_panelOrientation = type; };

    void emitChangePref();

signals:
    void changePref();
    
private:

    kfishPref();
    ~kfishPref();

    static kfishPref *s_prefs;
    
    // MAIN
    int m_numBubble; 
    int m_widthSpace;
    int m_fishScale;
    
    //FISHES
    bool m_fishSel;
    bool m_fishRan;
    int m_fishNumber;    
    QDict<QString> m_fishSelNum;
    
    // PANEL STUFF
    int m_width;
    int m_height;
    Orientation m_panelOrientation;

    KConfig *config;
};


#endif
