/*
    gbxrommetadata.cpp - Extract metadata(information) from GBX ROM file.

    Copyright (c) 2006      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "gbxrommetadata.h"

// Qt includes
#include <qdatastream.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>
#include <kmdcodec.h>

#include "nintendomakerlist.h"

GbxRomMetaData::GbxRomMetaData()
 : Kamefu::DefaultRomMetaData()
{
}


GbxRomMetaData::~GbxRomMetaData()
{
}


Kamefu::RomMetaInformation GbxRomMetaData::extractMetaInformation(KFileItem* item)
{
    return DefaultRomMetaData::extractMetaInformation(item);
}

Kamefu::RomMetaInformation GbxRomMetaData::extractMetaInformation(QIODevice* device)
{
	QByteArray makerCode(2);
	Q_UINT8 oldMakerCode, countryFlag;

	QString md5Hash, countryName(i18n("Unknown")), editorName(i18n("Unknown"));
	
	// Generate the MD5 Hash
	KMD5 context(0L);
	context.update(*device);
	md5Hash = context.hexDigest();

	QDataStream stream(device);
	stream.setByteOrder(QDataStream::LittleEndian);

	// Go to new maker code
	device->at(0x144);

	// Read the maker code
	stream.readRawBytes(makerCode.data(), makerCode.size());

	// Go to country flag.
	device->at(0x14a);
	stream >> countryFlag;
	// Read old maker code;
	stream >> oldMakerCode;

	// Get the information
	// Get the editor name from the maker code
	int result=0;
	if( makerCode[0] != 0 )
	{
		bool ok;
		QString sMaker(makerCode);
		result = sMaker.toInt(&ok, 16);
	}
	else
	{
		result = oldMakerCode;
	}

	result = (result >> 4) * 36 + (result & 0x0f);
	if(result > 0 || result <= nintendoMakerListLength)
		editorName = nintendoMakerList[result];

	if(countryFlag)
	{
		countryName = i18n("America/Europe");
	}
	else
	{
		countryName = i18n("Japan");
	}

	Kamefu::RomMetaInformation romMetaData;
	romMetaData.setEditor(editorName);
	romMetaData.setCountry(countryName);
	romMetaData.setMd5Hash(md5Hash);

	return romMetaData;
}
