/*
    gbasystem.cpp - Game Boy Advance Kamefu system plugin

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "gbasystem.h"

// KDE Includes
#include <kgenericfactory.h>
#include <kdebug.h>

// Kamefu includes
#include "rommetadatafactory.h"

#include "gbarommetadata.h"

typedef KGenericFactory<GbaSystem> GbaSystemFactory;
K_EXPORT_COMPONENT_FACTORY( kamefu_gba, GbaSystemFactory( "kamefu_gba" )  )

class GbaSystem::Private
{
};

GbaSystem::GbaSystem(QObject *parent, const char *name, const QStringList& /*args*/)
 : Kamefu::System(parent, name)
{
	
	if ( s_gbaSystem )
		kdDebug()<< k_funcinfo << "GBA system already initialized" << endl;
	else
		s_gbaSystem = this;

	d = new Private;

	registerSystemMimeType( QString::fromUtf8("application/x-rom-gba") );
	Kamefu::RomMetaDataFactory::self()->addRomMetaDataFactory( QString::fromUtf8("application/x-rom-gba"), new GbaRomMetaData);
}


GbaSystem::~GbaSystem()
{
	delete d;
	s_gbaSystem = 0L;	
}

GbaSystem *GbaSystem::system()
{
	return s_gbaSystem;
}

GbaSystem *GbaSystem::s_gbaSystem = 0L;

#include "gbasystem.moc"
