/*
    rommetadata.h - Base class used by RomMetaDataFactory.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef KAMEFUROMMETADATA_H
#define KAMEFUROMMETADATA_H

#include "rommetainformation.h"
#include <kfileitem.h>
#include <qiodevice.h>

namespace Kamefu 
{

/**
 * RomMetaData is the base class used by the factory RomMetaDataFactory. 
 * Derivated classes extract meta information from ROM file depending of the context.
 *
 * @author Michaël Larouche <michael.larouche@kdemail.net>
*/
class RomMetaData
{
public:
	RomMetaData();
	virtual ~RomMetaData();

	/**
	 * @brief Check if the file in path can be handled by this RomMetaData
	 * Default implementation return false.
	 * 
	 * @param path Path to the file.
	 * @return True if this RomMetaData can handle the file.
	 */
	virtual bool canHandle(const QString &path);

	/**
	 * Extract metainformation when file is a normal file.
	 * URL, rom name and system name must be filled by this method.
	 */
	virtual RomMetaInformation extractMetaInformation(KFileItem *item) = 0;
	/**
	 * Extract metainformation from a file into an archive(zip, tar,ar)
	 * URL, rom name and system name are filled by the Archive handler.
	 * No need to open the QIODevice, it is already opened by KArchiveEntry.
	 */
	virtual RomMetaInformation extractMetaInformation(QIODevice *);
};

}

#endif
