/*
    gamelauncher.h - Kamefu Game(ROM) Launcher

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef KAMEFUGAMELAUNCHER_H
#define KAMEFUGAMELAUNCHER_H

#include <qobject.h>

class KProcess;

namespace Kamefu {

/**
 * This class launch a ROM from a path.
 * It handle retrieving the emulator path and argument and execute the ROM.
 *
 * @author Michaël Larouche
*/
class GameLauncher : public QObject
{
Q_OBJECT
public:
    GameLauncher(QObject *parent = 0, const char *name = 0);
    ~GameLauncher();

public slots:
	/**
	 * Launch a game from a path.
	 * @param romPath Path to the Game(ROM)
	 */
	bool launchGame(const QString &romPath);

private slots:
	void processTerminated(KProcess *process);

};

}

#endif
