/*
    defaultrommetadata.cpp - Default RomMetaData, extract meta infromation from ROM KFilePlugin.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "defaultrommetadata.h"

// KDE includes
#include <kfileitem.h> 

// Kamefu includes.
#include "systemmanager.h"

namespace Kamefu {

DefaultRomMetaData::DefaultRomMetaData()
 : RomMetaData()
{
}


DefaultRomMetaData::~DefaultRomMetaData()
{
}


RomMetaInformation DefaultRomMetaData::extractMetaInformation(KFileItem *item)
{
	RomMetaInformation romMetaData;
			
	KFileMetaInfo metaInfo = item->metaInfo();
			
	QString md5Hash = metaInfo.value("md5Hash").toString();
	QString romName = item->url().fileName();
	// Remove extension from romName.
	romName = romName.left(romName.findRev("."));
	QString url = item->url().path();
	QString editor = metaInfo.value("editor").toString();
	QString country = metaInfo.value("country").toString();
	QString system = SystemManager::self()->guessSystemNameFromMimeType(metaInfo.mimeType());
			
	romMetaData.setMd5Hash(md5Hash);
	romMetaData.setUrl(url);
	romMetaData.setRomName(romName);
	romMetaData.setEditor(editor);
	romMetaData.setCountry(country);
	romMetaData.setSystem(system);

	return romMetaData;
}

RomMetaInformation DefaultRomMetaData::extractMetaInformation(QIODevice*)
{
	// Default RomMetaData can't use this method.
	return RomMetaInformation();
}

}
