/******************************************************************************
	styledromdisplay.h - A cool, styled HTML-based ROM info display.
	
	Copyright (c) 2006 by Brian S. Stephan
	bssteph@incorporeal.org
	
	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; either version 2 of the License, or     *
	* (at your option) any later version.                                   *
	*                                                                       *
	*************************************************************************
	
 *****************************************************************************/

#ifndef STYLEDROMDISPLAY_H
#define STYLEDROMDISPLAY_H

#include <khtml_part.h>
/**
	@brief Constants used in defining which parts to display.
	Use these as bitmasks to specify all the options you want.
	
	@author Brian S. Stephan <bssteph@incorporeal.org>
*/
enum StyledRomDisplayOptions {
	DISPLAY_ROMNAME = 1,
	DISPLAY_SYSTEM = 2,
	DISPLAY_TITLESCREEN = 4,
	DISPLAY_DEVELOPER = 8,
	DISPLAY_YEAR = 16,
	DISPLAY_COUNTRY = 32,
	DISPLAY_GENRE = 64,
	DISPLAY_SCREENSHOTS = 128
};

/**
	@brief A cool, styled HTML-based ROM info display.
	This is a specialized KHTMLPart for displaying some of a ROM's more
	interesting information in a stylized way. Eventually it will be able to
	be configured so specific information is shown. Shiny.
	
	@author Brian S. Stephan <bssteph@incorporeal.org>
*/
class StyledRomDisplay : public KHTMLPart {
	Q_OBJECT

public:
	// TODO: There's a lot left to be done. Loading of images (screenshots),
	// TODO: making the HTML output more configurable, loading CSS from files, ...
	/**
	 * Create a new StyledRomDisplayWidget.
	 * @param options display options
	 * @param parentWidget this widget's parent widget (where it gets drawn)
	 * @param widgetname name for the display widget
	 * @param parent this widget's real parent
	 * @param name the non-display widget's name
	 * @param prof GUI profile
	 */
	StyledRomDisplay(unsigned int options = 255, QWidget *parentWidget = 0, const char *widgetname = 0, QObject *parent = 0, const char * name = 0, GUIProfile prof = DefaultGUI);
	
	virtual ~StyledRomDisplay();
	
public slots:
	/**
	 * Set the ROM to display.
	 * @param romName the ROM to load
	 */
	void setRom(const QString &romUrl);

private:
	/**
	 * Generate the HTML that will be used in the part.
	 */
	void generateHTML();
	/**
	 * Generate the CSS for our default stylesheet.
	 */
	void generateCss();
	
private:
	class Private;
	Private *d;
};

#endif
