/******************************************************************************
	metadataeditdialog.cpp - Dialog for viewing/editing ROM metadata info.
	
	Copyright (c) 2006 by Brian S. Stephan
	bssteph@incorporeal.org
	Copyright (c) 2006 by Michaël Larouche <michael.larouche@kdemail.net>
	
	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; either version 2 of the License, or     *
	* (at your option) any later version.                                   *
	*                                                                       *
	*************************************************************************
	
 *****************************************************************************/

#include <kiconloader.h>
#include <klocale.h>
#include <kguiitem.h>

#include <qvbox.h>

#include "metadataedit.h"
#include "metadataeditdialog.h"

class MetadataEditDialog::Private
{
public:
	Private() : romEdit(NULL)
	{}
	
	MetadataEdit* romEdit;
};

// NOTE: Use buttons from KDialogBase, not our own buttons. Use Cancel and User1 button.
// NOTE: Use Tabbed mode to show the pages as tabs.
MetadataEditDialogPrivate::MetadataEditDialogPrivate(const QString& caption, QWidget *parent) :
	KDialogBase( KDialogBase::Tabbed, caption, KDialogBase::User1 | KDialogBase::Cancel, KDialogBase::User1, parent, "metadata_edit_dialog", true, false, KGuiItem(i18n("Save and Close"), SmallIconSet("filesave")) )
{
	m_overviewPage = addVBoxPage( i18n("Overview") );
}

MetadataEditDialog::MetadataEditDialog(const QString &romUrl, const QString &caption, QWidget *parent)
 : MetadataEditDialogPrivate(caption, parent), d(new Private)
{
	d->romEdit = new MetadataEdit(romUrl, m_overviewPage);

	init();
}

MetadataEditDialog::MetadataEditDialog(const KURL::List &romList, const QString &caption, QWidget *parent)
 : MetadataEditDialogPrivate(caption, parent), d(new Private)
{
	d->romEdit = new MetadataEdit(romList, m_overviewPage);

	init();
}

MetadataEditDialog::~MetadataEditDialog()
{
	delete d;
}

void MetadataEditDialog::init()
{
	connect(d->romEdit, SIGNAL(changed(bool)), this, SLOT(slotEnabledSaveButton(bool)));
	connect(d->romEdit, SIGNAL(metadataChanged(const QString&)), this, SIGNAL(metadataChanged(const QString&)));
	connect(d->romEdit, SIGNAL(metadataChanged(const KURL::List&)), this, SIGNAL(metadataChanged(const KURL::List&)));

	// Disable save button by default
	slotEnabledSaveButton(false);
}

void MetadataEditDialog::slotUser1()
{
	d->romEdit->save();
	close();
}

void MetadataEditDialog::slotEnabledSaveButton(bool enable)
{
	enableButton(KDialogBase::User1, enable);
}

#include "metadataeditdialog.moc"
