/*
    Kamefu, KDE All-Machine Emulator Frontend for UNIX
    Also a collection manager in its spare time ;)

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "kamefuapplication.h"

#include <qstringlist.h>

// KDE includes
#include <kdebug.h>

// Kamefu includes
#include "kamefumainwindow.h"
#include <systemmanager.h>
#include <collectionaccess.h>

KamefuApplication::KamefuApplication()
  : KUniqueApplication(true, true, true)
{
	mainWin = new KamefuMainWindow();
	Kamefu::SystemManager::self(); // Create the System Manager.
	Kamefu::SystemManager::self()->loadAllSystems();
	connect(Kamefu::SystemManager::self(), SIGNAL(allSystemsLoaded()), this, SLOT(slotAllSystemsLoaded()));
}


KamefuApplication::~KamefuApplication()
{
	kdDebug() << k_funcinfo << endl;
}


void KamefuApplication::slotAllSystemsLoaded()
{
	QStringList mimeList = Kamefu::SystemManager::self()->getRegistredMimeTypes();
	QStringList::const_iterator it;
	for(it = mimeList.begin(); it != mimeList.end(); ++it)
	{
		kdDebug() << k_funcinfo << "MIME type: " << *it << endl;
	}
	kdDebug() << k_funcinfo << "All systems loaded !" << endl;
}

int KamefuApplication::newInstance()
{
	setMainWidget(mainWin);
    return KUniqueApplication::newInstance();
}

#include "kamefuapplication.moc"
