/***************************************************************************
                           systemtray.cpp 
                             -------------------
    begin                : Son Okt 26 2003
    revision             : $Revision: 1.9 $
    last modified        : $Date: 2004/03/29 10:56:02 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kglobal.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kurldrag.h>
#include <kfiledialog.h>
#include <kaction.h>
#include <kstdaction.h>

#include <qtooltip.h>
 
#include "systemtray.h"
#include "systemtray.moc"


SystemTray::SystemTray(QWidget *parent, const char *name ) : KSystemTray(parent,name)
{
  kdDebug(555) << "Create System Tray" << endl;
   
  actionPlayPause = new KAction(i18n("Play/Pause"), "player_play", 0, this, SIGNAL(signalPlayPause()), actionCollection(), "trayplaypause");
  actionNext      = new KAction(i18n("Next Entry/Chapter"), "player_end", 0, this, SIGNAL(signalNext()), actionCollection(), "traynext");
  actionPrevious  = new KAction(i18n("Previous Entry/Chapter"), "player_start", 0, this, SIGNAL(signalPrev()), actionCollection(), "trayprevious");
  actionStop      = new KAction(i18n("Stop"), "player_stop", 0, this, SIGNAL(signalStop()), actionCollection(), "traystop");
  actionShowPlaylist = new KAction(i18n("Playlist"), "player_eject", 0, this, SIGNAL(signalShowPlaylist()), actionCollection(), "trayshowplaylist");
  actionOpenFile  = KStdAction::open( this, SLOT(slotOpenFiles()), actionCollection() );
  actionSaveStreamAs = new KAction(i18n("Save Stream As..."),"player_record", 0, this, SIGNAL(signalSaveStreamAs()), actionCollection(), "savestreamas");
  actionVideosettings = new KAction(i18n("&Video Settings"), "configure", 0, this, SIGNAL(signalShowVideosettings()), actionCollection(), "trayshowvideosettings");
  actionEqualizer = new KAction(i18n("&Equalizer"), "configure", 0, this, SIGNAL(signalShowEqualizer()), actionCollection(), "trayshowequalizer");
 
  actionVideosettings->plug(contextMenu());
  actionEqualizer->plug(contextMenu());
  contextMenu()->insertSeparator();
  actionOpenFile->plug(contextMenu());
  actionShowPlaylist->plug(contextMenu());
  contextMenu()->insertSeparator();

  actionPrevious->plug(contextMenu());
  actionNext->plug(contextMenu());
  actionStop->plug(contextMenu());
  actionPlayPause->plug(contextMenu());
  actionSaveStreamAs->plug(contextMenu());

  background = paletteBackgroundColor();
  setAcceptDrops(true);

  slotNormalIcon();    
  show();
}


SystemTray::~SystemTray()
{
}


void SystemTray::dragEnterEvent (QDragEnterEvent *dev)
{
  setPaletteBackgroundColor(QColor("red"));
  dev->accept(QUriDrag::canDecode(dev) || QTextDrag::canDecode(dev));
}


void SystemTray::dragLeaveEvent(QDragLeaveEvent*)
{
  setPaletteBackgroundColor(background);
}


void SystemTray::dropEvent(QDropEvent* dev)
{
//  kdDebug(555) << "Drop event" << endl;
  setPaletteBackgroundColor(background);
  KURL::List uris;

  if (KURLDrag::decode(dev, uris))
  {
    emit signalPlayFiles(uris);
  }
  else
  if (strcmp(dev->format(), "text/x-moz-url") == 0)    /* for mozilla drops - seems not to work! FIXME */
  {    
    QByteArray data = dev->encodedData("text/plain");
    QString md(data);
    kdDebug(555) << "Droped: " << md << endl;
    emit signalPlayFiles(KURL::List(KURL(md)));
  }
}


void SystemTray::slotOpenFiles()
{
  KURL::List urlList;
  urlList = KFileDialog::getOpenURLs(":kaffeineST_OpenFiles", QString::null, 0, i18n("Open File(s)"));

  if (!urlList.count()) return;
  emit signalPlayFiles(urlList);
}


/*************** set icons ****************/

void SystemTray::slotNormalIcon()
{  
  setPixmap(KGlobal::iconLoader()->loadIcon("kaffeine", KIcon::Panel, 22));
  QToolTip::add(this, i18n("Kaffeine Media Player"));
}


void SystemTray::slotPlayIcon()
{
  setPixmap(KGlobal::iconLoader()->loadIcon("kaffeine-play", KIcon::Panel, 22));
}


void SystemTray::slotPauseIcon()
{
  setPixmap(KGlobal::iconLoader()->loadIcon("kaffeine-pause", KIcon::Panel, 22));
}


void SystemTray::slotRecordIcon()
{
 setPixmap(KGlobal::iconLoader()->loadIcon("kaffeine-record", KIcon::Panel, 22)); 
}


void SystemTray::SetPlaying(const QString& title)
{
  QToolTip::add(this, title);
}



