/***************************************************************************
                           screenshotpreview.cpp
                             -------------------
    begin                : Don Mai 15 2003
    revision             : $Revision: 1.7 $
    last modified        : $Date: 2004/01/22 22:27:46 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J.  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kglobalsettings.h>
 
#include <qpainter.h>

#include "screenshotpreview.h"
#include "screenshotpreview.moc"


ScreenshotPreview::ScreenshotPreview(const QImage& img, QWidget *parent, const char *name )
  : KPreviewWidgetBase(parent,name)

{
  setMinimumWidth(200);
  previewImg = img.copy(); /* deep copy */
}


ScreenshotPreview::~ScreenshotPreview()
{
}


void ScreenshotPreview::showPreview(const KURL&) /* reimplemented to do nothing */
{
}


void ScreenshotPreview::clearPreview() /* reimplemented to do nothing */
{
}

/* show preview picture */

void ScreenshotPreview::paintEvent(QPaintEvent*)
{
  int imgHeight, posy;

  imgHeight = (int)((double) previewImg.height() / previewImg.width() * (width()-5));
  posy = (height() - imgHeight) / 2;

  QString info = QString::number(previewImg.width()) + "x" + QString::number(previewImg.height());

  QFont font = KGlobalSettings::generalFont();
  font.setPointSize(10);
  QFontMetrics met(font);
    
  QPainter painter(this);
  painter.drawImage(QRect(5, posy, width(), imgHeight), previewImg);

  painter.setFont(font);
  painter.drawText((width()-met.width(info))/2, posy + imgHeight + 20, info);
}



