/***************************************************************************
                           controlpanel.cpp 
                             -------------------
    begin                : Don Apr 17 2003
    revision             : $Revision: 1.19 $
    last modified        : $Date: 2004/04/16 11:22:41 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kglobalsettings.h>
#include <kdebug.h>

#include <qlayout.h>
#include <qnamespace.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfontmetrics.h>
#include <qregexp.h>

#include "controlpanel.h"
#include "controlpanel.moc"



ControlPanel::ControlPanel(QWidget *parent, const char *name ) : QWidget(parent,name), DCOPObject("PlaybackControl"),
 isPlaying(false), isPlayButton(true)
{
  setSizePolicy ( QSizePolicy (QSizePolicy::MinimumExpanding, QSizePolicy::Fixed) );
  
  QGridLayout* glayout = new QGridLayout(this, 2, 9);
  glayout->setMargin(2);
  glayout->setSpacing(2);

  MyHBox* timerBox = new MyHBox( this );
  timerBox->setSpacing(5);
  timerBox->setSizePolicy ( QSizePolicy (QSizePolicy::MinimumExpanding, QSizePolicy::Fixed) );
  connect( timerBox, SIGNAL(signalChangePosition(int)), this, SIGNAL(signalChangePosition(int)));
  
  playPausePB = new KPushButton(this);
  playPixmap = KGlobal::iconLoader()->loadIcon("player_play", KIcon::Small);
  pausePixmap = KGlobal::iconLoader()->loadIcon("player_pause", KIcon::Small);
  playPausePB->setPixmap(playPixmap);
  playPausePB->setFocusPolicy(QWidget::StrongFocus);
  glayout->addWidget(playPausePB, 1, 1);

  recordPB = new KPushButton(this);
  recordPB->setPixmap(KGlobal::iconLoader()->loadIcon("player_record", KIcon::Small));
  glayout->addWidget(recordPB, 1, 0);

  stopPB = new KPushButton(this); 
  stopPB->setPixmap(KGlobal::iconLoader()->loadIcon("player_stop", KIcon::Small));
  glayout->addWidget(stopPB, 1, 2);

  nextPB = new KPushButton(this);
  nextPB->setPixmap(KGlobal::iconLoader()->loadIcon("player_end", KIcon::Small));
  glayout->addWidget(nextPB, 1, 4);

  prevPB = new KPushButton(this);
  prevPB->setPixmap(KGlobal::iconLoader()->loadIcon("player_start", KIcon::Small));
  glayout->addWidget(prevPB, 1, 3);

  playListPB = new KPushButton(this);
  playListPB->setPixmap(KGlobal::iconLoader()->loadIcon("player_eject", KIcon::Small));
  glayout->addWidget(playListPB, 1, 5);
  connect(playListPB, SIGNAL(clicked()), this, SIGNAL(signalPlayList()));

  posSlider = new MySlider(Qt::Horizontal, timerBox);
  posSlider->setRange(0,65535);
  posSlider->setSteps(100, 1000);
  posSlider->setTracking( false );
  connect(posSlider, SIGNAL(sliderMoved(int)), timerBox, SIGNAL(signalChangePosition(int)));
  
  timeButton = new KPushButton(timerBox);
  QFontMetrics met( KGlobalSettings::generalFont() );
  timeButton->setFixedWidth( met.width("5:55:55")+18 );
  timeButton->setSizePolicy ( QSizePolicy (QSizePolicy::Fixed, QSizePolicy::Fixed) );
  connect(timeButton, SIGNAL(clicked()), this, SIGNAL(signalTogglePlayMode()));

  glayout->addMultiCellWidget( timerBox, 0, 0, 0, 7 );
  
  audioChannelCB = new KComboBox(this);
  audioChannelCB->insertItem(i18n("auto"));
  glayout->addWidget(audioChannelCB,1, 6);
  connect(audioChannelCB, SIGNAL(activated(int)), this, SIGNAL(signalSetAudioChannel(int)));

  subtitleCB = new KComboBox(this);
  subtitleCB->insertItem(i18n("off"));
  glayout->addWidget(subtitleCB,1, 7);
  connect(subtitleCB, SIGNAL(activated(int)), this, SIGNAL(signalSetSubtitleChannel(int)));

  volSlider = new  QSlider(Qt::Vertical, this);
  volSlider->setTickmarks(QSlider::Left);
  volSlider->setRange(-100, 0);
  volSlider->setSteps(1, 10);
  glayout->addMultiCellWidget(volSlider, 0, 1, 8, 8);
  connect(volSlider, SIGNAL(valueChanged(int)), this, SIGNAL(signalVolumeChanged(int)));


/*********** information **************/
  QToolTip::add(audioChannelCB, i18n("Audiochannel"));
  QWhatsThis::add(audioChannelCB, i18n("Here you can select the Audio-Channel, default is auto"));
  QToolTip::add(subtitleCB, i18n("Subtitles"));
  QWhatsThis::add(subtitleCB, i18n("Here you can select the Subtitle-Channel if any, and turn subtitles off (default)"));
  QToolTip::add(volSlider, i18n("Volume") + "    +/-");
  QToolTip::add(posSlider, i18n("Position") + "     " + i18n("Left") + "/" + i18n("Right"));
  QToolTip::add(timeButton,i18n("Change Counter-Mode"));
  QWhatsThis::add(timeButton, i18n("Click this button to change the counter-mode. Modes are: count forward, count backwards and percent of stream."));
  QToolTip::add(playPausePB, i18n("Play/Pause") + "    " + i18n("Space"));
  QToolTip::add(nextPB, i18n("Next Entry/Chapter") + "    " + i18n("Down"));
  QWhatsThis::add(nextPB, i18n("Plays next playlist entry or next chapter, if there are chapters"));
  QToolTip::add(prevPB, i18n("Previous Entry/Chapter") + "    " + i18n("Up"));
  QWhatsThis::add(prevPB, i18n("Plays previous playlist entry or previous chapter, if there are chapters"));
  QToolTip::add(playListPB, i18n("Playlist") + "    P");
  QToolTip::add(stopPB, i18n("Stop") + "    " + i18n("Backspace"));
  QToolTip::add(recordPB, i18n("Save Stream As...") + "    R");


  connect(playPausePB, SIGNAL(clicked()), this, SLOT(slotPlayPause()));
  connect(stopPB, SIGNAL(clicked()), this, SLOT(slotStop()));
  connect(prevPB, SIGNAL(clicked()), this, SLOT(slotPrev()));
  connect(nextPB, SIGNAL(clicked()), this, SLOT(slotNext()));
  connect(recordPB, SIGNAL(clicked()), this, SIGNAL(signalSaveStreamAs()));

  ResetControlPanel();
}


ControlPanel::~ControlPanel()
{
}


void ControlPanel::slotPosPlus()
{
  posSlider->addPage();
  emit signalChangePosition(posSlider->value());
}


void ControlPanel::slotPosMinus()
{
  posSlider->subtractPage();
  emit signalChangePosition(posSlider->value());
}
 

/****** switch between play and pause ******/ 
void ControlPanel::slotPlayPause()
{
  if (!isPlaying)
  {
    emit signalPlay();
  }
  else
  {

    if (!isPlayButton)
    {
       isPlayButton = true;
       playPausePB->setPixmap(playPixmap);
       emit signalPauseOn();
    }
    else
    {
      isPlayButton = false;
      playPausePB->setPixmap(pausePixmap);
      emit signalPauseOff();
    }     
  }
}                          


void ControlPanel::slotStop()
{  
  if (isPlaying)
   emit signalStop();
}


void ControlPanel::slotNext()
{
  if (isPlaying)
   emit signalPlayNext();
}


void ControlPanel::slotPrev()
{
  if (isPlaying)
   emit signalPlayPrevious();
}

    
void ControlPanel::ResetControlPanel()
{
  isPlaying = false;
  isPlayButton = true;
  playPausePB->setPixmap(playPixmap);
  timeButton->setText(QString("0:00:00"));
  if (recordPB->isDown())
    recordPB->setDown( false );
  posSlider->setValue(0);
}   


void ControlPanel::setVolume(int vol)
{
  volSlider->setValue(-vol);
}  


void ControlPanel::SetPlaying()
{
  isPlaying = true;
  isPlayButton = false;
  if (recordPB->isDown())
    recordPB->setDown( false );
  playPausePB->setPixmap(pausePixmap);  /*** set pause-button ****/
}


void ControlPanel::SetRecording()
{
  recordPB->setDown( true );
}  


bool ControlPanel::GetPlaying() const
{
  return isPlaying;  /*** is pause-button visible? ***/
}  


void ControlPanel::slotNewChannels(const QStringList& audio, const QStringList& subtitles, int currentAudio, int currentSub)
{
  audioChannelCB->clear();
  audioChannelCB->insertItem(i18n("auto"));
  audioChannelCB->insertStringList(audio);
  audioChannelCB->setCurrentItem(currentAudio+1);

  subtitleCB->clear();
  subtitleCB->insertItem(i18n("off"));
  subtitleCB->insertStringList(subtitles);
  subtitleCB->setCurrentItem(currentSub+1);

  QToolTip::add(subtitleCB,i18n("Subtitles")); 
}


void ControlPanel::slotNewSubtitles(QStringList subs, QString currentSub)
{
  QStringList tmpSubs = subs;
  this->subs = subs;
  
  for(unsigned int i = 0; i<tmpSubs.size(); i++)
  {
    QString tmp = tmpSubs[i].section('/',-1,-1);
    QRegExp *re = new QRegExp("^[a-z]*.[a-z]{3}$",false); //No dots are present in the sub name
    if (re->exactMatch(tmp))//Print first 8 letters
       tmpSubs[i] = tmp.left(8);
    else
       tmpSubs[i] = tmp.section('.',-2,-2);
  }
  tmpSubs.prepend(i18n("off"));
  subtitleCB->clear();  
  subtitleCB->insertStringList(tmpSubs);
  QToolTip::remove(subtitleCB);
  if(currentSub!=QString::null)
  {
    subtitleCB->setCurrentItem(subs.findIndex(currentSub)+1);
    QToolTip::add(subtitleCB,i18n("Subtitles") + ": " + currentSub.section('/',-1,-1));
  } 
  else
  {
    subtitleCB->setCurrentItem(0);
    QToolTip::add(subtitleCB,i18n("Subtitles") + ": " + i18n("off"));
  }
}

void ControlPanel::slotNewPosition(int pos, const QString& time)
{
  
  posSlider->SetValue(pos, false);
    
  timeButton->setText(time);
}



