/*
 * %kadu copyright begin%
 * Copyright 2008, 2010, 2011 Piotr Galiszewski (piotr.galiszewski@kadu.im)
 * Copyright 2012 Wojciech Treter (juzefwt@gmail.com)
 * Copyright 2008 Michał Podsiadlik (michal@kadu.net)
 * Copyright 2007, 2008, 2009, 2010, 2011, 2013 Rafał Malinowski (rafal.przemyslaw.malinowski@gmail.com)
 * Copyright 2010 Bartosz Brachaczek (b.brachaczek@gmail.com)
 * Copyright 2007, 2008 Dawid Stawiarski (neeo@kadu.net)
 * %kadu copyright end%
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MENU_ITEM_H
#define MENU_ITEM_H

#include "kadu-menu.h"

class QMenu;
class ActionDescription;

class MenuItem
{
	ActionDescription *Action;
	KaduMenu::MenuSection Section;
	int Priority;

public:
	MenuItem(ActionDescription *action, KaduMenu::MenuSection section, int priority = 0);

	bool operator < (const MenuItem &compareTo) const;

	ActionDescription * actionDescription() { return Action; }
	KaduMenu::MenuSection section() const { return Section; }
	int priority() const { return Priority; }

};

#endif // MENU_ITEM_H
