#ifndef __KADU_OSD_MANAGER_H
#define __KADU_OSD_MANAGER_H
#include <qptrlist.h>

#include "../notify/notify.h"
#include "chat_widget.h"
#include "osd_widget.h"
#include "osd_configuration_widget.h"

/**

	based on hints module

**/
class OSDManager : public Notifier, public ConfigurationUiHandler, public ToolTipClass,
ConfigurationAwareObject
{
	Q_OBJECT
	
	public:
		OSDManager(QWidget *parent=0, const char *name=0);
		~OSDManager();
		
		void reload(void);
		
		virtual void notify(Notification *notification);
		virtual CallbackCapacity callbackCapacity() { return CallbackSupported; }
		void copyConfiguration(const QString &fromEvent, const QString &toEvent);
		virtual NotifierConfigurationWidget *createConfigurationWidget(QWidget *parent = 0, char *name = 0);
		
		virtual void mainConfigurationWindowCreated(MainConfigurationWindow*);
		virtual void configurationUpdated();

		virtual void showToolTip(const QPoint &, const UserListElement &);
		virtual void hideToolTip();

		void openChat(OSDWidget *widget);
	
	public slots:
		void deleteAllWidgets(void);
		void removeWidget(OSDWidget *widget);
		void leftButtonSlot(OSDWidget *widget);
		void rightButtonSlot(OSDWidget *widget);
		void midButtonSlot(OSDWidget *widget);

	private:
		QPtrList<OSDWidget> widgets;
		OSDWidget *tipWidget;
		QWidget *overUserSyntax;
		int height;
		unsigned int new_osd;
		unsigned int corner;
		unsigned int separator;
		double translucency_level;
		int def_x;
		int def_y;
		OSDConfigurationWidget *configurationWidget;
		QString defaultSyntax;
		
		void addOSD(Notification *notification);
		void deleteWidget(OSDWidget *widget);
		OSDWidget *findWidget(const UserListElements &users);
		void processButtonPress(const QString &buttonName, OSDWidget *widget);
		void importConfiguration();
		void setDefaultValues();

	private slots:
		void timeout(int id, const UserGroup *group);
		void chatCreated(ChatWidget *widget);
		void toolTipClassesHighlighted(const QString &value);
	
	signals:
		void searchingForTrayPosition(QPoint& pos);
};
#endif
