/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include "weather_cfg_ui_handler.h"
#include "weather_global.h"

#include "config_file.h"
#include "icons_manager.h"

#include <qspinbox.h>
#include <qgroupbox.h>
#include <qhbox.h>
#include <qlistview.h>
#include <qheader.h>

WeatherCfgUiHandler::WeatherCfgUiHandler()
{
	// Load configuration UI
	//
	MainConfigurationWindow::registerUiFile( dataPath("kadu/modules/configuration/weather.ui"), this );
}

WeatherCfgUiHandler::~WeatherCfgUiHandler()
{
	// Unload configuration UI
	//
	MainConfigurationWindow::unregisterUiFile( dataPath("kadu/modules/configuration/weather.ui"), this );
}

void WeatherCfgUiHandler::mainConfigurationWindowCreated( MainConfigurationWindow* mainCfgWindow )
{
	ConfigGroupBox* weatherServersBox = mainCfgWindow->configGroupBox( "Weather", "General", "Weather servers", false );
	weatherServersBox->addWidget( new QLabel(tr("Servers priorites:"), weatherServersBox->widget() ), true );
	QHBox* serversBox = new QHBox( weatherServersBox->widget() );
	serversBox->setSpacing(5);
	serverList_ = new QListView( serversBox );
	serverList_->addColumn(tr("Server name"));
	serverList_->setColumnWidthMode(0, QListView::Maximum);
	serverList_->header()->hide();
	serverList_->setAllColumnsShowFocus(true);
	serverList_->setResizeMode(QListView::LastColumn);
	serverList_->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding ) );
	serverList_->setMaximumHeight( 70 );
	serverList_->setSorting( -1 );
	QVBox* buttonsBox = new QVBox( serversBox );
	buttonsBox->setSpacing(5);
	QPushButton* upButton = new QPushButton( tr("Up"), buttonsBox, "weather/up" );
	QPushButton* downButton = new QPushButton( tr("Down"), buttonsBox, "weather/down" );
	weatherServersBox->addWidget( serversBox, true );
	
	connect( upButton, SIGNAL(clicked()), this, SLOT(upClicked()));
	connect( downButton, SIGNAL(clicked()), this, SLOT(downClicked()));
	connect( mainCfgWindow->widgetById("weather/autodownload"), SIGNAL(toggled(bool)),
			 mainCfgWindow->widgetById("weather/hint_box"),     SLOT(setEnabled(bool)));
	connect( mainCfgWindow->widgetById("weather/autodownload"), SIGNAL(toggled(bool)),
			 mainCfgWindow->widgetById("weather/desc_box"),     SLOT(setEnabled(bool)));
	connect( mainCfgWindow->widgetById("weather/showhint"),  SIGNAL(toggled(bool)),
			 mainCfgWindow->widgetById("weather/hint_text"), SLOT(setEnabled(bool)));
	connect( mainCfgWindow->widgetById("weather/showhint"), SIGNAL(toggled(bool)),
			 mainCfgWindow->widgetById("weather/hint_day"), SLOT(setEnabled(bool)));
	connect( mainCfgWindow->widgetById("weather/updatedescription"), SIGNAL(toggled(bool)),
			 mainCfgWindow->widgetById("weather/desc_text"),         SLOT(setEnabled(bool)));
	connect( mainCfgWindow->widgetById("weather/updatedescription"), SIGNAL(toggled(bool)),
			 mainCfgWindow->widgetById("weather/desc_pos"),         SLOT(setEnabled(bool)));
	connect( mainCfgWindow->widgetById("weather/updatedescription"), SIGNAL(toggled(bool)),
			 mainCfgWindow->widgetById("weather/desc_day"),          SLOT(setEnabled(bool)));
	connect( serverList_, SIGNAL(pressed(QListViewItem* )), this, SLOT(serverListItemChanged(QListViewItem* )));
	connect( serverList_, SIGNAL(spacePressed(QListViewItem* )), this, SLOT(serverListItemChanged(QListViewItem* )));
	
	// Weather servers
	//
	WeatherGlobal::SERVERITERATOR serverIt = weather_global->servers_.begin();
	while( serverIt != weather_global->servers_.end() )
	{
		QCheckListItem* item = new QCheckListItem( serverList_, (*serverIt).name_, QCheckListItem::CheckBox );
		item->setOn( (*serverIt).use_ );
		item->moveItem( serverList_->lastItem() );
		++serverIt;
	}
}

void WeatherCfgUiHandler::configurationUpdated()
{
	// Weather servers
	//
	QCheckListItem* item = reinterpret_cast<QCheckListItem*>( serverList_->firstChild() );
	
	uint index = 0;
	while( item != 0 )
	{
		QString itemText = item->text();
		weather_global->setServerUsing( itemText, item->isOn() );
		weather_global->setServerPos( itemText, index );
		item = reinterpret_cast<QCheckListItem*>( item->nextSibling() );
		++index;
	}
}


void WeatherCfgUiHandler::serverListItemChanged( QListViewItem* item )
{
	if( item == 0 )
		return;

	QCheckListItem* checkItem = reinterpret_cast<QCheckListItem*>( item );
	if( checkItem->isOn() )
		return;
	
	QCheckListItem* listItem = reinterpret_cast<QCheckListItem*>( serverList_->firstChild() );
	
	while( listItem != 0 )
	{
		if( listItem->isOn() )
			return;
		listItem = reinterpret_cast<QCheckListItem*>( listItem->nextSibling() );
	}
	checkItem->setOn( true );
}

void WeatherCfgUiHandler::upClicked()
{
	QListViewItem* item = serverList_->currentItem();
	if( item != 0 )
	{
		QListViewItem* previous = item->itemAbove();
		if( previous != 0 )
			previous->moveItem( item );
	}
}

void WeatherCfgUiHandler::downClicked()
{
	QListViewItem* item = serverList_->currentItem();
	if( item != 0 )
	{
		QListViewItem* next = item->itemBelow();
		if( next != 0 )
			item->moveItem( next );
	}
}
