#include "portlistbox.h"
#include <alsa/asoundlib.h>
#include <stdio.h>

PortListBox::PortListBox(QWidget *parent, snd_seq_t *pseq, int preadflag) : QListBox(parent) {

    seq = pseq;
    readflag = preadflag;
    selected_port = -1;
    selected_client = -1;
    updateList(0);
}

int PortListBox::check_permission(snd_seq_port_info_t *pinfo, int perm) {
    if (((snd_seq_port_info_get_capability(pinfo) & perm) == perm) &&
        ! (snd_seq_port_info_get_capability(pinfo) & SND_SEQ_PORT_CAP_NO_EXPORT))
            return 1;
    return 0;
}

void PortListBox::list_ports(int perm) {
    
    snd_seq_client_info_t *cinfo;
    snd_seq_port_info_t *pinfo;
    char s[1024];
    int index, l1;
    
    selected_port = ((index = currentItem()) >= 0) ? port(index) : -1;
    selected_client = (index >= 0) ? client(index) : -1;
    clear();
    snd_seq_client_info_alloca(&cinfo);
    snd_seq_port_info_alloca(&pinfo);
    snd_seq_client_info_set_client(cinfo, -1);
    while (snd_seq_query_next_client(seq, cinfo) >= 0) {
        snd_seq_port_info_set_client(pinfo, snd_seq_client_info_get_client(cinfo));
        snd_seq_port_info_set_port(pinfo, -1);
        while(snd_seq_query_next_port(seq, pinfo) >= 0) {
//            if (check_permission(pinfo, perm) 
//               && (snd_seq_port_info_get_type(pinfo) & SND_SEQ_PORT_TYPE_MIDI_GENERIC)) {
// WORKAUROUND FOR ALSA_BUG, UNCOMMENT LINES ABOVE WHEN BUG HAS BEEN RESOLVED !!!
            if (check_permission(pinfo, perm) 
               && (snd_seq_client_info_get_client(cinfo) > 0)) {
                sprintf(s, "%d:%d %s", snd_seq_client_info_get_client(cinfo), 
                        snd_seq_port_info_get_port(pinfo), 
                        snd_seq_client_info_get_name(cinfo));
                insertItem(s);
            }
        }
    }
    if ((selected_port >= 0) && (selected_client >= 0)) {
      index = -1;
      for (l1 = 0; l1 < count(); l1++) {
        if ((port(l1) == selected_port) && (client(l1) == selected_client)) {
          index = l1;
        }
      } 
      if (index >= 0) {
        setSelected(index, true);
      } 
    }
} 

int PortListBox::client(int index) {
    
    int c, pos;
    bool ok;
    
    pos = this->text(index).find(":");
    c = this->text(index).left(pos).toInt(&ok, 10);
    
    return(c);
}

int PortListBox::port(int index) {
    
    int p, pos, len;
    bool ok;

    pos = this->text(index).find(":");
    len = this->text(index).find(" ") - pos;
    p = this->text(index).mid(pos+1, len).toInt(&ok, 10);
    
    return(p);
}

void PortListBox::updateList(int n) {

    if (readflag) {
        list_ports(SND_SEQ_PORT_CAP_READ|SND_SEQ_PORT_CAP_SUBS_READ);
    } else {
        list_ports(SND_SEQ_PORT_CAP_WRITE|SND_SEQ_PORT_CAP_SUBS_WRITE);
    }
}
