//
// C++ Implementation: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "k9prefdvd.h"
#include <kurlrequester.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include "k9tools.h"
#include "k9dvd.h"
k9prefDVD::k9prefDVD(QWidget* parent)
: QWidget(parent)
{
    Ui_prefDVD.setupUi(this);
    k9Config config;
#ifdef BACKLITE
    Ui_prefDVD.urOutput->setMode(KUrlRequester::DIRECTORY);
    Ui_prefDVD.gbPerformances->hide();
#else
    Ui_prefDVD.urOutput->setMode(KFile::Directory);
#endif
    Ui_prefDVD.urOutput->setUrl(KUrl(config.getPrefOutput()));
    Ui_prefDVD.ckK3b->setChecked(config.getPrefK3b());

    Ui_prefDVD.ckAutoBurn->setChecked(config.getPrefAutoBurn());
    Ui_prefDVD.ckQuickScan->setChecked(config.getQuickScan());
    Ui_prefDVD.ckDvdAuthor->setChecked(config.getUseDvdAuthor());
    Ui_prefDVD.ckDelTmpFiles->setChecked(config.getPrefDelTmpFiles());
    Ui_prefDVD.ckMpegChapter->setChecked(config.getMpegChapters());
    Ui_prefDVD.ckUserOps->setChecked(config.getPrefUserOps());
    Ui_prefDVD.sbSize->setValue(config.getPrefSize());
    Ui_prefDVD.sbSize->setSuffix(" "+ i18n("MB"));

    loadLanguages(Ui_prefDVD.cbAudioLang);
    loadLanguages(Ui_prefDVD.cbSubtitlesLang);
    Ui_prefDVD.cbAudioLang->setCurrentIndex(Ui_prefDVD.cbAudioLang->findData(config.getPrefAudioLang()));

    Ui_prefDVD.cbSubtitlesLang->setCurrentIndex(Ui_prefDVD.cbSubtitlesLang->findData(config.getPrefSubtitleLang() ));
    switch(config.getPrefReadAhead()) {
	case 0  :
	 	Ui_prefDVD.cbReadAhead->setCurrentIndex(1);
		break;
	case 8  :
	 	Ui_prefDVD.cbReadAhead->setCurrentIndex(2);
		break;
	default:
	 	Ui_prefDVD.cbReadAhead->setCurrentIndex(0);
		break;
    }

}

void k9prefDVD::loadLanguages(QComboBox *_combo) {
  lng arrLng[200];
  k9DVD::LangList(arrLng);
  int index=0;
  _combo->clear();
  do {
     _combo->addItem(QString("%1 - %2").arg(arrLng[index].code).arg(arrLng[index].name),arrLng[index].code);
      index++;
  } while (arrLng[index].code[0]!=0);

}

k9prefDVD::~k9prefDVD()
{
}

/*$SPECIALIZATION$*/

void k9prefDVD::save() {
    k9Config config;
    config.setPrefOutput( Ui_prefDVD.urOutput->url().path());
    config.setPrefK3b(Ui_prefDVD.ckK3b->isChecked());
    config.setPrefAutoBurn( Ui_prefDVD.ckAutoBurn->isChecked());
    config.setPrefSize(Ui_prefDVD.sbSize->value());
    config.setQuickScan( Ui_prefDVD.ckQuickScan->isChecked());
    config.setUseDvdAuthor( Ui_prefDVD.ckDvdAuthor->isChecked());    
    config.setPrefDelTmpFiles(Ui_prefDVD.ckDelTmpFiles->isChecked());
    config.setMpegChapters(Ui_prefDVD.ckMpegChapter->isChecked());
    config.setPrefUserOps(Ui_prefDVD.ckUserOps->isChecked());
    config.setPrefAudioLang(Ui_prefDVD.cbAudioLang->itemData(Ui_prefDVD.cbAudioLang->currentIndex()).toString());
    config.setPrefSubtitleLang(Ui_prefDVD.cbSubtitlesLang->itemData(Ui_prefDVD.cbSubtitlesLang->currentIndex()).toString());
    switch(Ui_prefDVD.cbReadAhead->currentIndex()) {
	case 0  :
	 	config.setPrefReadAhead(-1);
		break;
	case 1  :
	 	config.setPrefReadAhead(0);
		break;
	case 2:
	 	config.setPrefReadAhead(8);
		break;
    }

    config.save();
}

