/***************************************************************************
 *   Copyright (C) 2007 by Jean-Michel   *
 *   jm_petit@laposte.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "k9phonon.h"
#include "k9dvdtitle.h"
#include <Phonon/VolumeSlider>
#include <Phonon/SeekSlider>


k9Phonon::k9Phonon(QWidget *parent)
 : QWidget(parent)
{
    m_media=new Phonon::MediaObject(this);

    Ui_phonon.setupUi(this);
    QVBoxLayout *layout = new QVBoxLayout(Ui_phonon.wVideo);

    Phonon::VideoWidget *m_vwidget = new Phonon::VideoWidget(this);
    layout->addWidget(m_vwidget);

    Phonon::AudioOutput *m_aoutput = new Phonon::AudioOutput(Phonon::VideoCategory, this);

    Phonon::createPath(m_media, m_aoutput);
    Phonon::createPath(m_media, m_vwidget);

//    connect(m_playButton, SIGNAL(clicked()), m_media, SLOT(play()));
    Phonon::VolumeSlider *m_volumeSlider = new Phonon::VolumeSlider(this);
    Phonon::SeekSlider *m_seekSlider = new Phonon::SeekSlider(this);
    m_seekSlider->setMediaObject(m_media);
    m_volumeSlider->setAudioOutput(m_aoutput);
  Ui_phonon.bPlay->setIcon(SmallIcon("media-playback-start"));
    Ui_phonon.bStop->setIcon(SmallIcon("media-playback-stop"));
    QGridLayout *Grid=new QGridLayout(Ui_phonon.frControl);
    Grid->addWidget(Ui_phonon.bStop,0,0);
    Grid->addWidget(Ui_phonon.bPlay,0,1);
    Grid->addWidget(m_seekSlider,0,2);
    Grid->addWidget(m_volumeSlider,0,3);
    connect(Ui_phonon.bStop,SIGNAL(clicked()),this,SLOT(bStopClick()));
    connect(Ui_phonon.bPlay,SIGNAL(clicked()),this,SLOT(bPlayClick()));
}

void k9Phonon::bStopClick() {
  m_media->stop();
}

void k9Phonon::bPlayClick() {
  m_media->play();
}

void k9Phonon::open(k9DVD *_dvd,k9DVDTitle *_title,int chapter) {
    setDevice(_dvd->getDevice());

    m_source=new Phonon::MediaSource(Phonon::Dvd,m_device);
    m_media->setCurrentSource(*m_source);

    m_controller=new Phonon::MediaController(m_media);
    m_controller->setAutoplayTitles(false);
    m_controller->setCurrentTitle(_title->getnumTitle());
    m_controller->setCurrentChapter(1);

    m_media->play();

}

void k9Phonon::setDevice(const QString & _device){
    m_device=_device;
    m_source=new Phonon::MediaSource(Phonon::Dvd,m_device);
    m_media->setCurrentSource(*m_source);

}


k9Phonon::~k9Phonon()
{
}


