//
// C++ Implementation:
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "k9common.h"
#include "k9menuedit.h"
#include "k9menueditor.h"
#include "k9menu.h"
#include "k9title.h"
#include "k9newdvd.h"
#include <qwmatrix.h>
#include <qlayout.h>
#include <kfontdialog.h>
#include "k9menubutton.h"
#include <kurlrequester.h>
#include <kcolorbutton.h>
#include <qcombobox.h>
#include <klocale.h>
#include <qlabel.h>
#include <kiconloader.h>




k9MenuEdit::k9MenuEdit(QWidget* parent, const char* name,Q3Canvas *_canvas)
        : QWidget(parent) {
    Ui_menuEdit.setupUi(this);
    Ui_menuEdit.bAddText->setIcon (SmallIcon("add"));
    m_noUpdate=false;
    m_canvas=_canvas;
    m_format=PAL;
    m_imageHeight=576;
    QGridLayout *grid=new QGridLayout(Ui_menuEdit.frame);
    m_menuEditor=new k9MenuEditor(*m_canvas,Ui_menuEdit.frame);
    grid->addWidget(m_menuEditor,0,0);
    m_canvas->resize(720,m_imageHeight);
    m_text=NULL;
    m_menuEditor->setMenu(this);
    connect(m_menuEditor,SIGNAL(itemSelected()),this,SLOT(itemSelected()));
    Ui_menuEdit.cbPosTitle->setEnabled(false);
}
void k9MenuEdit::updateTextPos(const QPoint &_point) {
    emit updatePos(_point);
}

void k9MenuEdit::itemSelected() {
    bool unselect=true;
    m_noUpdate=true;
    m_canvas->update();
    Ui_menuEdit.urBackground->setUrl(KUrl(""));
    if (m_menuEditor->getSelected()) {
        //     m_menuEditor->getSelected()->select(true);
        Ui_menuEdit.cbColor->setColor(m_menuEditor->getSelected()->getColor());
        Ui_menuEdit.leTitle->setText(m_menuEditor->getSelected()->getText());
        Ui_menuEdit.cbPosTitle->setEnabled(true);
        Ui_menuEdit.cbPosTitle->setCurrentIndex(m_menuEditor->getSelected()->getTextPosition()-1);
        Ui_menuEdit.urBackground->setEnabled(true);
        m_canvas->update();
    } else if (m_menuEditor->getMoving()) {
        if (m_menuEditor->getMoving()->rtti()==Q3CanvasItem::Rtti_Text) {
            m_text=(Q3CanvasText*)m_menuEditor->getMoving();
            Ui_menuEdit.leTitle->setText(m_text->text());
            Ui_menuEdit.cbColor->setColor(m_text->color());
            Ui_menuEdit.cbPosTitle->setEnabled(false);
            Ui_menuEdit.urBackground->setEnabled(false);
        }
    } else {
        Ui_menuEdit.urBackground->setEnabled(true);
        Ui_menuEdit.cbPosTitle->setEnabled(false);
    }
    m_noUpdate=false;
}





k9MenuEdit::~k9MenuEdit() {

}

/*$SPECIALIZATION$*/


void k9MenuEdit::bFontClick() {
    if (m_menuEditor->getSelected()) {
        k9MenuButton *b=m_menuEditor->getSelected();
        QFont myFont(b->getFont());
        int result = KFontDialog::getFont( myFont );
        if ( result == KFontDialog::Accepted && m_menuEditor->getSelected() ) {
            QList <k9MenuButton*> *l=m_menuEditor->getSelection();
            foreach (k9MenuButton *b,*l) {
                b->setFont(myFont);
            }
        }
    } else {
        if (m_text) {
            QFont myFont(m_text->font());
            int result = KFontDialog::getFont( myFont );
            if ( result == KFontDialog::Accepted  )
                setFont(myFont);
        }

    }
}

void k9MenuEdit::urBackgroundSelected(const KUrl &_url) {
    if ( m_menuEditor->getSelected() ) {
//If a button is selected, set the button image ...
        k9MenuButton *b=(k9MenuButton*)m_menuEditor->getSelected();
        QImage img;
        img.load(_url.toLocalFile());
        b->setImage(img);
    } else {
//...otherwise, set the menu background image
        QImage img;
        img.load(_url.toLocalFile());
        img=img.scaled(720,m_imageHeight,Qt::KeepAspectRatioByExpanding);
        setBackgroundImage(img);
    }
}

void k9MenuEdit::cbColorChanged(const QColor &_color) {
    if (m_noUpdate)
        return;
    if ( m_menuEditor->getSelected() ) {
        QList <k9MenuButton*> *l=m_menuEditor->getSelection();
        foreach (k9MenuButton *b,*l) {
            b->setColor(_color);
        }
        //m_menuEditor->getSelected()->setColor(_color);
    } else {
        setColor(_color);
    }

}

void k9MenuEdit::cbPosTitleActivated(int _value) {
    if (m_noUpdate)
        return;
    if ( m_menuEditor->getSelected() ) {
        QList <k9MenuButton*> *l=m_menuEditor->getSelection();
        foreach (k9MenuButton *b,*l) {
            b->setTextPosition((k9MenuButton::eTextPosition)(_value+1));
        }
    }
}

void k9MenuEdit::setBackgroundImage(const QImage &_image) {
    m_background=_image;
    m_canvas->setBackgroundPixmap(QPixmap::fromImage(_image));
    emit backgroundImageChanged(_image);
}

void k9MenuEdit::leTitleChanged(const QString &_value) {
    if (m_noUpdate)
        return;
    if ( m_menuEditor->getSelected() ) {
        QList <k9MenuButton*> *l=m_menuEditor->getSelection();
        foreach (k9MenuButton *b,*l) {
            QString c=_value;
            b->setText(c.replace("%n",QString::number(b->getNum())));
        }
        //m_menuEditor->getSelected()->setText(_value);
    } else {
        setText(_value);
    }
}


void k9MenuEdit::setText(const QString &_value) {
    if (m_text)
        m_text->setText(_value);
    m_canvas->update();
    emit textChanged(_value);
}

void k9MenuEdit::setFont(const QFont &_value) {
    if (m_text)
        m_text->setFont(_value);
    m_canvas->update();
    emit textFontChanged(_value);
}

void k9MenuEdit::setColor(const QColor &_value) {
    if (m_text)
        m_text->setColor(_value);
    m_canvas->update();
    emit textColorChanged(_value);
}

Q3CanvasText* k9MenuEdit::getText() const {
    return m_text;
}


k9MenuEdit::eFormat k9MenuEdit::getFormat() const {
    return m_format;
}


void k9MenuEdit::setFormat(const eFormat& _value) {
    m_format = _value;
    if (_value==NTSC)
        m_imageHeight=480;
    else
        m_imageHeight=576;
    QPixmap pix=m_canvas->backgroundPixmap();
    QImage img=pix.toImage().scaled(720,m_imageHeight);
    m_canvas->resize(720,m_imageHeight);
    m_menuEditor->setMaximumSize(QSize(724,m_imageHeight+4));
    m_canvas->setBackgroundPixmap(QPixmap::fromImage(img));
}


Q3Canvas *k9MenuEdit::getCanvas()  {
    return m_canvas;
}


void k9MenuEdit::setCanvas(Q3Canvas* _value) {
    m_canvas = _value;
    m_text=NULL;
    m_menuEditor->setCanvas(_value);
    m_canvas->resize(720,m_imageHeight);
    m_canvas->update();
    m_menuEditor->updateContents();
}

void k9MenuEdit::titleSelected(k9Title *_title) {
    disconnect (this,SIGNAL(startScriptChanged(const QString&)),0,0);
    disconnect (this,SIGNAL(endScriptChanged(const QString&)),0,0);
    Ui_menuEdit.cbEnd->setEnabled(true);
    m_menuEditor->clearSelection();
    Ui_menuEdit.lTitle->setText(i18n("Title %1 Menu",_title->getNum()+1));
    setCanvas(_title->getMenu()->getCanvas());
    m_menuType=TITLEMENU;
    Ui_menuEdit.cbStart->clear();
    Ui_menuEdit.cbEnd->clear();
    m_startScripts.clear();
    m_endScripts.clear();


    Ui_menuEdit.cbStart->addItem(i18n("Play Menu"));
    m_startScripts << "";
    Ui_menuEdit.cbStart->addItem(i18n("Play Title"));
    m_startScripts << "if (g1==0) {g1=1; jump title 1 chapter 1;}";
    if (_title->getMenu()->getStartScript() !="")
        Ui_menuEdit.cbStart->setCurrentIndex(Ui_menuEdit.cbStart->count()-1);
    connect (this,SIGNAL(startScriptChanged(const QString&)),_title->getMenu(),SLOT(setStartScript(const QString&)));

    Ui_menuEdit.cbEnd->addItem(i18n("Play Root Menu"));
    m_endScripts << "g6=0; call vmgm menu;";
    Ui_menuEdit.cbEnd->addItem(i18n("Play Title Menu"));
    m_endScripts << "call menu;";
    k9NewDVD *newDVD=(k9NewDVD*)_title->parent() ;
    k9NewDVDItems *items=newDVD->getTitles();
    foreach (k9Title *title,*items) {
        Ui_menuEdit.cbEnd->addItem(i18n("Play Title %1",title->getNum()+1));
        QString script=QString("g6=%1; call vmgm menu;" ).arg(title->getNum()+1);
        m_endScripts << script;
    }
    for (int i=0;i<m_endScripts.count();i++ ) {
        if (_title->getMenu()->getEndScript()== m_endScripts.at(i))
            Ui_menuEdit.cbEnd->setCurrentIndex(i);
    }
    connect (this,SIGNAL(endScriptChanged(const QString&)),_title->getMenu(),SLOT(setEndScript(const QString&)));

}

void k9MenuEdit::rootSelected(k9NewDVD *_newDVD) {
    disconnect (this,SIGNAL(startScriptChanged(const QString&)),0,0);
    disconnect (this,SIGNAL(endScriptChanged(const QString&)),0,0);
    Ui_menuEdit.cbEnd->setEnabled(false);
    m_menuEditor->clearSelection();
    Ui_menuEdit.lTitle->setText(i18n("Root Menu"));
    setCanvas(_newDVD->getRootMenu()->getCanvas());
    m_menuType=ROOTMENU;
    Ui_menuEdit.cbStart->clear();
    m_startScripts.clear();
    Ui_menuEdit.cbStart->addItem(i18n("Play Menu"));
    m_startScripts << "";
    k9NewDVDItems *items=_newDVD->getTitles();
    foreach (k9Title *title,*items) {
        Ui_menuEdit.cbStart->addItem(i18n("Play Title %1",title->getNum()+1));
        // QString script=QString("if (g5==0) {g5=1; jump title %1;}" ).arg(title->getNum()+1);
        QString script=QString("g6=%1;" ).arg(title->getNum()+1);
        m_startScripts << script;
        if (script==_newDVD->getRootMenu()->getStartScript())
            Ui_menuEdit.cbStart->setCurrentIndex(Ui_menuEdit.cbStart->count()-1);
    }
    connect (this,SIGNAL(startScriptChanged(const QString&)),_newDVD->getRootMenu(),SLOT(setStartScript(const QString&)));
}

void k9MenuEdit::bAddTextClick() {
    m_text=new Q3CanvasText(m_canvas);
    m_text->show();
    m_menuEditor->setMoving(m_text);
    setText(Ui_menuEdit.leTitle->text());
    setColor(Ui_menuEdit.cbColor->color());
}

void k9MenuEdit::cbStartActivated (int _value) {
    emit startScriptChanged(m_startScripts[_value]);
}

void k9MenuEdit::cbEndActivated (int _value) {
    emit endScriptChanged(m_endScripts[_value]);
}
