//
// C++ Implementation: k9videocodecs
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9videocodecs.h"
#include <qstringlist.h>

class _k9VideoCodec
{
public:
    _k9VideoCodec():name(""),fourcc(""),optPass1(""),optPass2(""),optOnePass(""){};
   _k9VideoCodec(QString _name,QString _fourcc,QString _optOnePass,QString _optPass1,QString _optPass2) {
      name=_name;
      fourcc=_fourcc;
      optOnePass=_optOnePass;
      optPass1=_optPass1;
      optPass2=_optPass2; 
   }
   QString name;
   QString fourcc;
   QString optOnePass;
   QString optPass1;
   QString optPass2;
}; 


k9VideoCodecs::k9VideoCodecs(QObject *parent)
 : QObject(parent)
{
   m_config=new k9Config();
   QStringList slLabels=m_config->getCodecLabels();
   QStringList slCodecs=m_config->getCodecVideo();
   bool bReset;
   bReset=slLabels.count()==0;
   if (!bReset)
        bReset=slCodecs.count() !=  slLabels.count()*4; 
   //adds default codecs
   if (bReset) {
      reset();
      m_config=new k9Config();
      slLabels=m_config->getCodecLabels();
      slCodecs=m_config->getCodecVideo();
   }  

   QStringList::iterator c=slCodecs.begin();
   int cpt=0;
   for (QStringList::iterator i=slLabels.begin();i!=slLabels.end() ;++i) {
        QString fourcc=(*c);
        c++;
        QString o1=(*c);
        c++;
        QString o2=(*c);
        c++;
        QString o3=(*c);
        c++;

        m_codecs[cpt++]=_k9VideoCodec((*i),fourcc,o1,o2,o3);
   }
   delete m_config;

}

void k9VideoCodecs::reset() {
      m_codecs[0]=_k9VideoCodec("copy","","-ovc copy","-ovc copy","-ovc copy");
      m_codecs[1]=_k9VideoCodec("XviD","","-ovc xvid -xvidencopts bitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc xvid -xvidencopts bitrate=$VIDBR:turbo:pass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc xvid -xvidencopts bitrate=$VIDBR:turbo:pass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[2]=_k9VideoCodec("x264","","-ovc x264 -x264encopts bitrate=$VIDBR:threads=0 -vf scale=$WIDTH:$HEIGHT","-ovc x264 -x264encopts bitrate=$VIDBR:turbo=1:pass=$PASS:threads=0 -vf scale=$WIDTH:$HEIGHT","-ovc x264 -x264encopts bitrate=$VIDBR:turbo=1:pass=$PASS:threads=0 -vf scale=$WIDTH:$HEIGHT");     
      m_codecs[3]=_k9VideoCodec("MJPEG","","-ovc lavc -lavcopts vcodec=mjpeg:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=mjpeg:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=mjpeg:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[4]=_k9VideoCodec("LJPEG","","-ovc lavc -lavcopts vcodec=ljpeg:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=ljpeg:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=ljpeg:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[5]=_k9VideoCodec("H261","","-ovc lavc -lavcopts vcodec=h261:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=h261:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=h261:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[6]=_k9VideoCodec("H263","","-ovc lavc -lavcopts vcodec=h263:vhq:v4mv:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=h263:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=h263:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[7]=_k9VideoCodec("H263+","","-ovc lavc -lavcopts vcodec=h263p:vhq:v4mv:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=h263p:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=h263p:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[8]=_k9VideoCodec("MPEG-4 (DivX 4/5)","DIVX","-ovc lavc -lavcopts vcodec=mpeg4:vhq:v4mv:vqmin=2:vbitrate=$VIDBR  -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=mpeg4:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=mpeg4:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[9]=_k9VideoCodec("MS MPEG-4 (DivX 3)","DIVX","-ovc lavc -lavcopts vcodec=msmpeg4:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=msmpeg4:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=msmpeg4:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[10]=_k9VideoCodec("MS MPEG-4 v2","","-ovc lavc -lavcopts vcodec=msmpeg4v2:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=msmpeg4v2:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=msmpeg4v2:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[11]=_k9VideoCodec("WMV7","","-ovc lavc -lavcopts vcodec=wmv1:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=wmv1:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=wmv1:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[12]=_k9VideoCodec("WMV8","","-ovc lavc -lavcopts vcodec=wmv2:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=wmv2:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=wmv2:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");

      m_codecs[13]=_k9VideoCodec("RealVideo","","-ovc lavc -lavcopts vcodec=rv10:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=rv10:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=rv10:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[14]=_k9VideoCodec("MPEG-1 Video","","-ovc lavc -lavcopts vcodec=mpeg1video:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=mpeg1video:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=mpeg1video:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[15]=_k9VideoCodec("MPEG-2 Video","","-ovc lavc -lavcopts vcodec=mpeg2video:vhq:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=mpeg2video:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=mpeg2video:vhq:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[16]=_k9VideoCodec("Huffmann yuv","","-ovc lavc -lavcopts vcodec=huffyuv:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:format=422p -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=huffyuv:vhq:v4mv:vqmin=2:vbitrate=$VIDBR::format=422p:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=huffyuv:vhq:v4mv:vqmin=2:vbitrate=$VIDBR::format=422p:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[17]=_k9VideoCodec("ffv Huffmann","","-ovc lavc -lavcopts vcodec=ffvhuff:vhq:v4mv:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=ffvhuff:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=ffvhuff:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[18]=_k9VideoCodec("ASUS v1","","-ovc lavc -lavcopts vcodec=asv1:vhq:v4mv:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=asv1:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=asv1:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[19]=_k9VideoCodec("ASUS v2","","-ovc lavc -lavcopts vcodec=asv2:vhq:v4mv:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=asv2:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=asv2:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      m_codecs[20]=_k9VideoCodec("flv","","-ovc lavc -lavcopts vcodec=flv:vhq:v4mv:vqmin=2:vbitrate=$VIDBR -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=flv:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT","-ovc lavc -lavcopts vcodec=flv:vhq:v4mv:vqmin=2:vbitrate=$VIDBR:turbo:vpass=$PASS -vf scale=$WIDTH:$HEIGHT");
      save();

}

void k9VideoCodecs::save() {
   m_config=new k9Config();

    QStringList labels;
    QStringList options;
    for (QMap<int,_k9VideoCodec>::iterator i=m_codecs.begin();i!=m_codecs.end();++i) {
        labels << i.value().name;
        options << i.value().fourcc;
        options << i.value().optOnePass;
        options << i.value().optPass1;
        options << i.value().optPass2;
    }
    m_config->setCodecLabels(labels);
    m_config->setCodecVideo(options);
    m_config->save();
    delete m_config;
}




int k9VideoCodecs::count() {
   return m_codecs.count();
}

void k9VideoCodecs::setFourcc(int _num,QString _value) {
    m_codecs[_num].fourcc=_value;
}
void k9VideoCodecs::setOptions0(int _num,QString _value) {
    m_codecs[_num].optOnePass=_value;
}
void k9VideoCodecs::setOptions1(int _num,QString _value) {
    m_codecs[_num].optPass1=_value;
}
void k9VideoCodecs::setOptions2(int _num,QString _value) {
    m_codecs[_num].optPass2=_value;
}

void k9VideoCodecs::setCodecName(int _num,QString _value) {
    m_codecs[_num].name=_value;
}

QString k9VideoCodecs::getFourcc(int _num) {
   return m_codecs[_num].fourcc;
}

QString k9VideoCodecs::getOptions0(int _num) {
   return m_codecs[_num].optOnePass;
}

QString k9VideoCodecs::getOptions1(int _num) {
   return m_codecs[_num].optPass1;
}

QString k9VideoCodecs::getOptions2(int _num) {
   return m_codecs[_num].optPass2;
}
QString k9VideoCodecs::getCodecName(int _num) {
   return m_codecs[_num].name;
}

void k9VideoCodecs::remove(int _num) {
    int nb=count();
    if (nb>0) {
        for(int i=_num;i<nb-1;i++) {
            m_codecs[i]=m_codecs[i+1];
        }
        m_codecs.remove(nb-1);
    }
}

k9VideoCodecs::~k9VideoCodecs()
{

}

