//
// C++ Implementation: k9tools
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9tools.h"
#include <kstandarddirs.h>
#include <qdir.h>
#include <QComboBox>
#include <sys/vfs.h>
#include <KMessageBox>
#include <KLocale>


bool k9Tools::checkProgram(QString _progName,bool _msg) {
   bool res= KStandardDirs::findExe( _progName,NULL,false) !=NULL ;
   if (_msg && !res) 
	KMessageBox::error(0,i18n("Error starting program %1",_progName),i18n("Running program"));
   return res;
}

void k9Tools::clearOutput(QString name) {
    QDir dir(name);
    //delete files in directory
    QStringList lst = dir.entryList(QStringList( "*"),QDir::Files |QDir::Hidden );
    foreach (QString c,lst) {
        //QString c(( *it ).latin1() );
        dir.remove (c);
    }
    //scanning subdir
    QStringList lstdir = dir.entryList( QStringList("*"),QDir::Dirs );
    foreach ( QString c,lstdir) {
        if ((c!=".") && c!="..") {
            clearOutput(dir.absoluteFilePath(c));
            dir.rmdir(c);
        }
    }

}

void k9Tools::setComboText(QComboBox *_cb,const QString &_text) {
        int i = _cb->findText(_text);
        if (i != -1)
            _cb->setCurrentIndex(i);
        else if (_cb->isEditable())
            _cb->setEditText(_text);
        else
            _cb->setItemText(_cb->currentIndex(), _text);
}

long k9Tools::getFreeSpace(const QString &_path) {
struct statfs sfs;
if (statfs(_path.toAscii(),&sfs) !=-1) {
   uint64_t fs=((uint64_t)sfs.f_bavail*(uint64_t)sfs.f_bsize);
   fs/=(1024*1024);
   return fs;
} else
   return -1;
}
