//
// C++ Interface: 
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef K9MAIN_H
#define K9MAIN_H

#include <qobject.h>
#include <qstring.h>
#include <kmessagebox.h>
#include <qlistview.h>
#include <ksimpleconfig.h>
#include "kcddrive.h"
#include <qptrlist.h>
#include "images.h"
#include "kviewmpeg2.h"
#include <kmainwindow.h>
#include "kconfigdlg.h"
#include <kaboutdata.h>
#include <qevent.h>
#include "k9mainw.h"




enum eStreamType {SUB,AUD,VID,NONE};

class LvItem : public QListViewItem
{
public:
  LvItem( QListViewItem *parent)
      : QListViewItem( parent), obj( NULL ) { streamType=NONE;}
  LvItem( QListView *parent)
      : QListViewItem( parent), obj( NULL ) {streamType=NONE;}
 eStreamType streamType;
  QObject *obj;
  virtual int rtti () const;
};

class k9Main;
class k9DVD;
class  k9DVDAudioStream;
class  k9DVDSubtitle;
class k9DVDTitle;
class KLibFactory;

class ckLvItem : public QCheckListItem
{
public:
  ckLvItem( QListViewItem *parent,k9Main *dlg)
      : QCheckListItem( parent,"",QCheckListItem::CheckBox){ mainDlg=dlg; obj=NULL;streamType=NONE;language="";}
  ckLvItem( QListView *parent,k9Main *dlg)
      : QCheckListItem( parent,"",QCheckListItem::CheckBox){ mainDlg=dlg; obj=NULL;streamType=NONE;language="";}
 eStreamType streamType;
  k9Main *mainDlg;
  QObject *obj;
  QString language;
  virtual int rtti () const;
protected:  
  void stateChange(bool state);
};

class ckLvLangItem : public QCheckListItem
{
public:
  ckLvLangItem( QListViewItem *parent,k9Main *dlg)
      : QCheckListItem( parent,"",QCheckListItem::CheckBox){ mainDlg=dlg; streamType=NONE;}
 eStreamType streamType;
  k9Main *mainDlg;
  QString language;
protected:  
  void stateChange(bool state);
};



class k9DVDListItem : public QObject
{
  Q_OBJECT
public:
  k9DVDAudioStream *audioStream;
  k9DVDSubtitle *subtitle;
  k9DVDTitle *title;
  ckLvItem *listItem;
  eStreamType streamType;
public:
  k9DVDListItem(QObject *DVD,ckLvItem *List,eStreamType type);
};




class k9Main : public MainDlg
{
  Q_OBJECT

public:
  k9Main(QWidget* parent = 0, const char* name = 0,  const QStringList &sl=0 );
  ~k9Main();
  /*$PUBLIC_FUNCTIONS$*/
  void addTitle(k9DVDTitle *track);
  void updateSelection();
  void checkAll(bool state);
  void checkTitle(bool state, ckLvItem *_item);
  void checkLang(QString lang, eStreamType streamType,bool state);
  bool getupdating();
  void saveSettings();

  //streamanalyze stream;
  k9DVD *dvd;
private slots:
  virtual void          ckMenuClick();
  virtual void          listView1CurrentChanged( QListViewItem * );
  virtual void          cbTitleActivated( int );
  virtual void          cbStartActivated( int );
  virtual void          bDevicesClick();
  virtual void          bSaveClick();

public slots:
  /*$PUBLIC_SLOTS$*/
  virtual void          PreviewTitle();
  virtual void          Copy();
  virtual void          Open();

protected:
  /*$PROTECTED_FUNCTIONS$*/
  QObjectList items;
  k9DVDListItem *addListItem(QObject *DVD,ckLvItem *List,eStreamType type);

  void readSettings();
  void readDrives();
  QPtrList<QListViewItem> lvItems;
  QPtrList <ckLvLangItem> langAudItems;
  QPtrList <ckLvLangItem> langSubItems;
  ckLvItem * root;
  QObjectList driveList;
  QObjectList recorderList;
  kCDDrives drives;
  QPixmap pxVideo;
  QPixmap pxSound;
  QPixmap pxText;
  kViewMPEG2 viewer;
  bool updating;
   void fillTitleList();
   void closeEvent( QCloseEvent* ce );
   void closeDVD();
   KLibFactory *m_factory;;
protected slots:
  /*$PROTECTED_SLOTS$*/
  void slot_progress(QString str);
  void itemRenamed ( QListViewItem *item, int col );

signals: // Signals
  /** No descriptions */
  void sig_progress(QString str);
private:
    void fillLvLanguages();
    void updateLvLang(const eStreamType streamType,const QString & lang) ;
};

#endif

