// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements property_collection, which provides a default implementation of iproperty_collection
		\author Tim Shead (tshead@k-3d.com)
*/

#include "ideletable.h"
#include "iuser_property.h"
#include "property_collection.h"
#include "result.h"

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// property_collection

property_collection::property_collection()
{
}

property_collection::~property_collection()
{
	for(properties_t::iterator property = m_properties.begin(); property != m_properties.end(); ++property)
	{
		if(dynamic_cast<iuser_property*>(*property))
			delete dynamic_cast<ideletable*>(*property);
	}
}

void property_collection::register_property(iproperty& Property)
{
	m_properties.push_back(&Property);
	m_changed_signal.emit(0);
}

void property_collection::unregister_property(iproperty& Property)
{
	m_properties.erase(std::remove(m_properties.begin(), m_properties.end(), &Property), m_properties.end());
	m_changed_signal.emit(0);
}

const iproperty_collection::properties_t& property_collection::properties()
{
	return m_properties;
}

iproperty_collection::properties_changed_signal_t& property_collection::properties_changed_signal()
{
	return m_changed_signal;
}

} // namespace k3d


