#ifndef K3DSDK_BITMAP_MODIFIER_H
#define K3DSDK_BITMAP_MODIFIER_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "data.h"
#include "i18n.h"
#include "ibitmap_sink.h"
#include "ibitmap_source.h"
#include "bitmap.h"

namespace k3d
{

/// Provides a boilerplate implementation of a node that acts both as a bitmap source and a bitmap sink
/** \todo Rewrite this for consistency with bitmap_source, mesh_source, and mesh_modifier */
template<typename base_t>
class bitmap_modifier :
	public base_t,
	public ibitmap_source,
	public ibitmap_sink
{
public:
	bitmap_modifier(idocument& Document) :
		base_t(Document),
		m_input(init_owner(*this) + init_name("input_bitmap") + init_label(_("Input Bitmap")) + init_description(_("Input bitmap")) + init_value<bitmap*>(0)),
		m_output(init_owner(*this) + init_name("output_bitmap") + init_label(_("Output Bitmap")) + init_description(_("Output output")) + init_slot(sigc::mem_fun(*this, &bitmap_modifier<base_t>::on_create_bitmap)))
	{
	}

	iproperty& bitmap_source_output()
	{
		return m_output;
	}

	iproperty& bitmap_sink_input()
	{
		return m_input;
	}

protected:
	virtual void on_create_bitmap(k3d::bitmap& Bitmap) = 0;
	
	k3d_data(bitmap*, immutable_name, change_signal, no_undo, local_storage, no_constraint, writable_property, no_serialization) m_input;
	k3d_data(bitmap*, immutable_name, change_signal, no_undo, demand_storage, no_constraint, read_only_property, no_serialization) m_output;
};

} // namespace k3d

#endif // !K3DSDK_BITMAP_MODIFIER_H

