#python

import k3d

def innovate():
	# Give folks a chance to bail ...
	if k3d.Application.ui.query_message("Are you sure?  Don't run this script on a real working document!", ["OK", "Cancel"]) == 2:
		return

	doc = k3d.Document

	# Start recording changes for undo-purposes ...
	doc.start_change_set()
	try:
		# Deliver "value" ...
		for object in doc.objects:
			object.name = "Microsoft " + object.name + " (TM)"

		# Finish recording undos ...
		doc.finish_change_set("Innovate!")

		# Communicate the good news to our "customer"!
		k3d.Application.ui.message("You have been Innovated ... check your Object List (it's undo-able)")
	except:
		doc.cancel_change_set()
		raise

innovate()
