#python

import k3d

doc = k3d.Document
doc.start_change_set()
try:
	frozen_mesh = doc.new_object("FrozenMesh")
	frozen_mesh.name = "Blobby Test"

	mesh = frozen_mesh.new_mesh()
	positions = ((-.5, .5, 0), (.5, .5, 0), (.5, -.5, 0), (-.5, -.5, 0))
	for position in positions:
		mesh.new_point(position)

	blobby = mesh.new_blobby()

#	blobby.root = blobby.new_add(blobby.new_ellipsoid(mesh.points[0]), blobby.new_ellipsoid(mesh.points[1]))
	ellipsoids = []
	for point in mesh.points:
		ellipsoids.append(blobby.new_ellipsoid(point))

	blobby.root = blobby.new_add(ellipsoids)

	mesh_instance = doc.new_object("MeshInstance")
	mesh_instance.name = "Blobby Test Instance"
	mesh_instance.scale = (5, 5, 5)
	doc.set_dependency(mesh_instance.get_property("input_mesh"), frozen_mesh.get_property("output_mesh"))

	doc.finish_change_set("Create Test Blobby")

except:
	doc.cancel_change_set()
	raise

