// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "window.h"
#include <k3dsdk/application.h>
#include <gdk/gdkkeysyms.h>

namespace libk3dngui
{

/////////////////////////////////////////////////////////////////////////////
// window

window::window(const std::string& Name, k3d::icommand_node* const Parent) :
	base(Gtk::WINDOW_TOPLEVEL),
	ui_component(Name, Parent)
{
	k3d::application().safe_to_close_signal().connect(sigc::mem_fun(*this, &window::safe_to_close));
	k3d::application().close_signal().connect(sigc::mem_fun(*this, &window::close));
}

window::~window()
{
}

bool window::on_key_press_event(GdkEventKey* event)
{
	if(event->keyval == GDK_Escape)
		{
			safe_close();
			return true;
		}

	return base::on_key_press_event(event);
}

bool window::on_delete_event(GdkEventAny* event)
{
	safe_close();
	return true;
}

bool window::safe_to_close()
{
	return on_safe_to_close();
}

void window::safe_close()
{
	if(safe_to_close())
		close();
}

void window::close()
{
	on_close();
	delete this;
}

bool window::on_safe_to_close()
{
	return true;
}

void window::on_close()
{
}

} // namespace libk3dngui


