#ifndef NGUI_FILE_SELECTION_H
#define NGUI_FILE_SELECTION_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/ipath_property.h>
#include <string>

namespace Gtk { class FileChooserDialog; }
namespace Gtk { class Window; }
namespace boost { namespace filesystem { class path; } }

namespace libk3dngui
{

/// Prompts the user for a filepath
bool get_file_path(const k3d::ipath_property::mode_t Mode, const std::string& Type, const std::string& Prompt, const boost::filesystem::path& OldPath, boost::filesystem::path& Result);
/// Prompts the user for a filepath, using a custom dialog
bool get_file_path(Gtk::FileChooserDialog& Chooser, const k3d::ipath_property::mode_t Mode, const std::string& Type, const std::string& Prompt, const boost::filesystem::path& OldPath, boost::filesystem::path& Result);

} // namespace libk3dngui

#endif // !NGUI_FILE_SELECTION_H


