// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your argument) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \author Timothy M. Shead (tshead@k-3d.com)
*/

#include "cursors.h"

#include <k3dsdk/log.h>
#include <k3dsdk/result.h>

#include <gdkmm/cursor.h>
#include <gdkmm/window.h>
#include <gtkmm/widget.h>

#include <iostream>

namespace libk3dngui
{

void set_cursor(Gtk::Widget& Widget, const Glib::RefPtr<Gdk::Pixbuf>& Cursor)
{
	return_if_fail(Widget.get_window());
	return_if_fail(Cursor);
	Widget.get_window()->set_cursor(Gdk::Cursor(Widget.get_display(), Cursor, 0, 0));
}

} // namespace libk3dngui

