#ifndef NGUI_APPLICATION_STATE_H
#define NGUI_APPLICATION_STATE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/data.h>

namespace libk3dngui
{

/// This ugly little fellow stores global (application-wide) user interface state in one place to minimize coupling between UI components
class iapplication_state
{
public:
	/// Set to true when batch (no user intervention) mode is enabled for the UI
	virtual bool& batch_mode() = 0;

	/// Defines storage for the current global assign hotkeys mode
	typedef k3d_data(bool, immutable_name, change_signal, no_undo, local_storage, no_constraint, no_property, no_serialization) assign_hotkeys_t;
	/// Set to true while dynamic hotkey assignment is enabled
	virtual assign_hotkeys_t& assign_hotkeys() = 0;

protected:
	iapplication_state() {}
	iapplication_state(const iapplication_state&) {}
	iapplication_state& operator=(const iapplication_state&) { return *this; }
	virtual ~iapplication_state() {}
};

/// Singleton access to the global application_state_t object
iapplication_state& application_state();

} // namespace libk3dngui

#endif // NGUI_APPLICATION_STATE_H

