// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your argument) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \author Timothy M. Shead (tshead@k-3d.com)
*/

#include "application_state.h"
#include <k3dsdk/i18n.h>

namespace libk3dngui
{

namespace detail
{

/////////////////////////////////////////////////////////////////////////////
// application_state_implementation

class application_state_implementation :
	public iapplication_state,
	public sigc::trackable
{
public:
	application_state_implementation() :
		m_batch_mode(false),
		m_assign_hotkeys(init_name("assign_hotkeys") + init_label(_("Assign Hotkeys")) + init_description(_("When on, allows the user to assign hotkeys")) + init_value(false))
	{
	}

	bool& batch_mode()
	{
		return m_batch_mode;
	}

	assign_hotkeys_t& assign_hotkeys()
	{
		return m_assign_hotkeys;
	}

	/// Stores the batch (no user intervention) mode state
	bool m_batch_mode;
	/// Stores the current global assign hotkeys state
	assign_hotkeys_t m_assign_hotkeys;
};

} // namespace detail

iapplication_state& application_state()
{
	static iapplication_state* instance = 0;
	if(!instance)
		instance = new detail::application_state_implementation();

	return *instance;
}

} // namespace libk3dngui


