// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Timothy M. Shead (tshead@k-3d.com)
*/

#include <k3dsdk/classes.h>
#include <k3dsdk/mesh_modifier.h>
#include <k3dsdk/mesh_selection_sink.h>
#include <k3dsdk/module.h>
#include <k3dsdk/node.h>
#include <k3dsdk/persistent.h>

namespace libk3dselection
{

/////////////////////////////////////////////////////////////////////////////
// froze_selection

class froze_selection :
	public k3d::mesh_selection_sink<k3d::mesh_modifier<k3d::persistent<k3d::node> > >
{
	typedef k3d::mesh_selection_sink<k3d::mesh_modifier<k3d::persistent<k3d::node> > > base;

public:
	froze_selection(k3d::idocument& Document) :
		base(Document)
	{
		m_input_mesh.changed_signal().connect(sigc::mem_fun(*this, &froze_selection::on_reset_geometry));
		m_mesh_selection.changed_signal().connect(sigc::mem_fun(*this, &froze_selection::on_reset_geometry));
		m_output_mesh.need_data_signal().connect(sigc::mem_fun(*this, &froze_selection::on_create_geometry));
	}

	void on_reset_geometry()
	{
		m_output_mesh.reset();
	}

	k3d::mesh* on_create_geometry()
	{
		// If we don't have any input data, we're done ...
		k3d::mesh* const input = m_input_mesh.value();
		if(!input)
			return 0;

		// Make a copy of the input geometry ...
		k3d::mesh* const output = new k3d::mesh();
		k3d::deep_copy(*input, *output);
		k3d::replace_selection(m_mesh_selection.value(), *output);

		return output;
	}

	void load(k3d::xml::element& Element, const k3d::ipersistent::load_context& Context) 	 
	{ 	 
		base::load(Element, Context);

		// Handle backwards-compatibility ...
		k3d::xml::element* const xml_selections = k3d::xml::find_element(Element, "selections"); 	 
		if(!xml_selections) 	 
			return; 	 

		k3d::load_mesh_selection(m_mesh_selection.internal_value(), *xml_selections, Context);
	} 	 

	
	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<
			k3d::document_plugin<froze_selection>,
			k3d::interface_list<k3d::imesh_source,
			k3d::interface_list<k3d::imesh_sink > > > factory(
			k3d::classes::FrozenSelection(),
			"FrozenSelection",
			_("Freezes the selection defined by its input"),
			"Selection",
			k3d::iplugin_factory::EXPERIMENTAL);

		return factory;
	}
};

/////////////////////////////////////////////////////////////////////////////
// frozen_selection_factory

k3d::iplugin_factory& frozen_selection_factory()
{
	return froze_selection::get_factory();
}

} // namespace libk3dselection


