#ifndef OBJECT_MODEL_H
#define OBJECT_MODEL_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares classes for implementing a scripting object model in Python
		\author Anders Dahnielson (anders@dahnielson.com)
		\author Romain Behar (romainbehar@yahoo.com)
		\author Timothy M. Shead (tshead@k-3d.com)
*/

extern "C"
{
#include <Python.h>
}

#include <k3dsdk/iscript_engine.h>

namespace k3d { class iunknown; }

namespace libk3dpython
{

/// Initializes the object model, returning a reference to the "k3d" module
PyObject* init_object_model();
/// Initializes the execution context
void init_context(PyObject* Module, const k3d::iscript_engine::context_t& Context);
/// Reflects changes to the execution context back into C++ land
void update_context(PyObject* Module, k3d::iscript_engine::context_t& Context);

} // namespace libk3dpython

#endif // !OBJECT_MODEL_H
