#ifndef K3DSDK_I18N_H
#define K3DSDK_I18N_H

#ifdef HAVE_CONFIG_H

	#include "config.h"
	
#endif // HAVE_CONFIG_H

#ifdef ENABLE_NLS

	#include <libintl.h>

	#define _(String) gettext(String)
	
	#ifdef gettext_noop
		#define N_(String) gettext_noop(String)
	#else
		#define N_(String) (String)
	#endif
	
#else // ENABLE_NLS

	#define _(String) (String)
	#define N_(String) (String)
	#define textdomain(String) 
	#define gettext(String) (String)
	#define dgettext(Domain, String) (String)
	#define dcgettext(Domain, String, Type) (String)
	#define bindtextdomain(Domain, Directory) 
	#define bind_textdomain_codeset(Domain, Codeset) 

#endif // !ENABLE_NLS 

#endif // K3DSDK_I18N_H

