// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Timothy M. Shead (tshead@k-3d.com)
*/

#include <k3dsdk/module.h>

/// Namespace reserved for the mesh plugin module, to protect public symbols from name clashes with other modules
namespace libk3dmesh
{

extern k3d::iplugin_factory& array_1d_factory();
extern k3d::iplugin_factory& bevel_faces_factory();
extern k3d::iplugin_factory& bevel_points_factory();
extern k3d::iplugin_factory& cap_hole_factory();
extern k3d::iplugin_factory& catmull_clark_subdivision_factory();
extern k3d::iplugin_factory& delete_selected_factory();
extern k3d::iplugin_factory& extrude_faces_factory();
extern k3d::iplugin_factory& face_normals_factory();
extern k3d::iplugin_factory& filter_faces_by_color_factory();
extern k3d::iplugin_factory& freehand_polygon_factory();
extern k3d::iplugin_factory& frozen_mesh_factory();
extern k3d::iplugin_factory& join_points_factory();
extern k3d::iplugin_factory& knot_curve_factory();
extern k3d::iplugin_factory& lawn_factory();
extern k3d::iplugin_factory& lightning_factory();
extern k3d::iplugin_factory& link_points_factory();
extern k3d::iplugin_factory& lissajous_curve_factory();
extern k3d::iplugin_factory& make_bilinear_patches_factory();
extern k3d::iplugin_factory& make_creases_factory();
extern k3d::iplugin_factory& make_path_factory();
extern k3d::iplugin_factory& make_sds_factory();
extern k3d::iplugin_factory& merge_faces_factory();
extern k3d::iplugin_factory& merge_mesh_factory();
extern k3d::iplugin_factory& mesh_instance_factory();
extern k3d::iplugin_factory& mesh_stats_factory();
extern k3d::iplugin_factory& move_first_edge_factory();
extern k3d::iplugin_factory& newell_primitive_factory();
extern k3d::iplugin_factory& planar_map_factory();
extern k3d::iplugin_factory& poly_cone_factory();
extern k3d::iplugin_factory& poly_cube_factory();
extern k3d::iplugin_factory& poly_cushion_factory();
extern k3d::iplugin_factory& poly_cylinder_factory();
extern k3d::iplugin_factory& poly_grid_factory();
extern k3d::iplugin_factory& poly_sphere_factory();
extern k3d::iplugin_factory& poly_terrain_fft_factory();
extern k3d::iplugin_factory& poly_terrain_hfbm_factory();
extern k3d::iplugin_factory& poly_torus_factory();
extern k3d::iplugin_factory& polygonize_bicubic_patches_factory();
extern k3d::iplugin_factory& polyhedron_factory();
extern k3d::iplugin_factory& quadrilateral_remeshing_factory();
extern k3d::iplugin_factory& sds_corner_factory();
extern k3d::iplugin_factory& sds_crease_factory();
extern k3d::iplugin_factory& select_clockwise_factory();
extern k3d::iplugin_factory& select_companion_factory();
extern k3d::iplugin_factory& select_face_by_number_factory();
extern k3d::iplugin_factory& select_point_by_number_factory();
extern k3d::iplugin_factory& selected_point_number_factory();
extern k3d::iplugin_factory& set_material_factory();
extern k3d::iplugin_factory& shear_points_factory();
extern k3d::iplugin_factory& smooth_shade_factory();
extern k3d::iplugin_factory& sphere_eversion_factory();
extern k3d::iplugin_factory& sphereize_points_factory();
extern k3d::iplugin_factory& split_edges_factory();
extern k3d::iplugin_factory& split_faces_factory();
extern k3d::iplugin_factory& split_faces_parallel_factory();
extern k3d::iplugin_factory& starfield_factory();
extern k3d::iplugin_factory& subdivide_faces_factory();
extern k3d::iplugin_factory& tag_color_factory();
extern k3d::iplugin_factory& triangulate_faces_factory();

} // namespace libk3dmesh

K3D_MODULE_START(k3d::uuid(0x9541a786, 0x49714986, 0x8ec61790, 0xf6c9456c), Registry)
	Registry.register_factory(libk3dmesh::array_1d_factory());
	Registry.register_factory(libk3dmesh::bevel_faces_factory());
	Registry.register_factory(libk3dmesh::bevel_points_factory());
	Registry.register_factory(libk3dmesh::cap_hole_factory());
	Registry.register_factory(libk3dmesh::catmull_clark_subdivision_factory());
	Registry.register_factory(libk3dmesh::delete_selected_factory());
	Registry.register_factory(libk3dmesh::extrude_faces_factory());
	Registry.register_factory(libk3dmesh::face_normals_factory());
	Registry.register_factory(libk3dmesh::filter_faces_by_color_factory());
	Registry.register_factory(libk3dmesh::freehand_polygon_factory());
	Registry.register_factory(libk3dmesh::frozen_mesh_factory());
	Registry.register_factory(libk3dmesh::join_points_factory());
	Registry.register_factory(libk3dmesh::knot_curve_factory());
	Registry.register_factory(libk3dmesh::lawn_factory());
	Registry.register_factory(libk3dmesh::lightning_factory());
	Registry.register_factory(libk3dmesh::link_points_factory());
	Registry.register_factory(libk3dmesh::lissajous_curve_factory());
	Registry.register_factory(libk3dmesh::make_bilinear_patches_factory());
	Registry.register_factory(libk3dmesh::make_creases_factory());
	Registry.register_factory(libk3dmesh::make_path_factory());
	Registry.register_factory(libk3dmesh::make_sds_factory());
	Registry.register_factory(libk3dmesh::merge_faces_factory());
	Registry.register_factory(libk3dmesh::merge_mesh_factory());
	Registry.register_factory(libk3dmesh::mesh_instance_factory());
	Registry.register_factory(libk3dmesh::mesh_stats_factory());
	Registry.register_factory(libk3dmesh::move_first_edge_factory());
	Registry.register_factory(libk3dmesh::newell_primitive_factory());
	Registry.register_factory(libk3dmesh::planar_map_factory());
	Registry.register_factory(libk3dmesh::poly_cone_factory());
	Registry.register_factory(libk3dmesh::poly_cube_factory());
	Registry.register_factory(libk3dmesh::poly_cushion_factory());
	Registry.register_factory(libk3dmesh::poly_cylinder_factory());
	Registry.register_factory(libk3dmesh::poly_grid_factory());
	Registry.register_factory(libk3dmesh::poly_sphere_factory());
	Registry.register_factory(libk3dmesh::poly_terrain_fft_factory());
	Registry.register_factory(libk3dmesh::poly_terrain_hfbm_factory());
	Registry.register_factory(libk3dmesh::poly_torus_factory());
	Registry.register_factory(libk3dmesh::polygonize_bicubic_patches_factory());
	Registry.register_factory(libk3dmesh::polyhedron_factory());
	Registry.register_factory(libk3dmesh::quadrilateral_remeshing_factory());
	Registry.register_factory(libk3dmesh::sds_corner_factory());
	Registry.register_factory(libk3dmesh::sds_crease_factory());
	Registry.register_factory(libk3dmesh::select_clockwise_factory());
	Registry.register_factory(libk3dmesh::select_companion_factory());
	Registry.register_factory(libk3dmesh::select_face_by_number_factory());
	Registry.register_factory(libk3dmesh::select_point_by_number_factory());
	Registry.register_factory(libk3dmesh::selected_point_number_factory());
	Registry.register_factory(libk3dmesh::set_material_factory());
	Registry.register_factory(libk3dmesh::smooth_shade_factory());
	Registry.register_factory(libk3dmesh::sphere_eversion_factory());
	Registry.register_factory(libk3dmesh::split_edges_factory());
	Registry.register_factory(libk3dmesh::split_faces_factory());
	Registry.register_factory(libk3dmesh::split_faces_parallel_factory());
	Registry.register_factory(libk3dmesh::starfield_factory());
	Registry.register_factory(libk3dmesh::subdivide_faces_factory());
	Registry.register_factory(libk3dmesh::tag_color_factory());
	Registry.register_factory(libk3dmesh::triangulate_faces_factory());
K3D_MODULE_END


