#ifndef K3DUI_VIEWPORT_WINDOW_H
#define K3DUI_VIEWPORT_WINDOW_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/signal_system.h>

namespace k3d
{

// Forward declarations
class idocument;
class iviewport;

namespace viewport
{

/////////////////////////////////////////////////////////////////////////////
//

class window :
	public SigC::Object
{
public:
	window(idocument& Document);
	~window();

	/// Attaches the window to a new viewport (may be called multiple times)
	void attach(iviewport& Viewport);

private:
	/// Called by the signal system when it's time to close this window
	void on_close();

	class implementation;
	implementation* const m_implementation;
};

} // namespace viewport

} // namespace k3d

#endif // K3DUI_VIEWPORT_WINDOW_H


