#ifndef K3D_SIGNAL_SYSTEM_H
#define K3D_SIGNAL_SYSTEM_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#if defined K3D_HAVE_SIGC_1_0

	#include <sigc++/signal_system.h>
	#include <sigc++/bind.h>

#elif defined K3D_HAVE_SIGC_1_2

	#include <sigc++/sigc++.h>
	#include <sigc++/bind.h>
	#include <sigc++/hide.h>

#elif defined K3D_HAVE_SIGC_2_0

	#include <sigc++/compatibility.h>
	#include <sigc++/bind.h>
	#include <sigc++/hide.h>

#else

	#error sigc++ version undefined - did you remember to run configure?

#endif // K3D_HAVE_SIGC_2_0

#endif // !K3D_SIGNAL_SYSTEM_H


