#ifndef K3DSDK_SELECTION_H
#define K3DSDK_SELECTION_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "iselection.h"

namespace k3d
{

// Forward declarations
class idag;
class idocument;
class iunknown;
class mesh;

/// Returns true iff the given mesh contains a selected object of any type
const bool contains_selection(const mesh& Mesh);
/// Convenience function for turning a single selectable object into a selection set
const iselection::selection_t make_selection(iunknown& Object);
/// Returns a "deepened" version of a selection (expands it to include the components of the objects within the selection)
const iselection::selection_t deep_selection(idag& Dag, const iselection::selection_t& Selection);
/// Selects the given objects and notifies observers
void select(idocument& Document, const iselection::selection_t& Selection);
/// Deselects the given objects and notifies observers
void deselect(idocument& Document, const iselection::selection_t& Selection);
/// Deselects everything within the given document
void deselect_all(idocument& Document);

/// Quietly attempts to set mouse focus for the provided object
void set_mouse_focus(idocument& Document, iunknown& Object);
/// Quietly releases mouse focus iff the provided object has it
void release_mouse_focus(idocument& Document, iunknown& Object);

} // namespace k3d

#endif // !K3DSDK_SELECTION_H
