from base64 import b64encode

from twisted.internet.defer import inlineCallbacks, returnValue

from juju.providers.common.launch import LaunchMachine

from .machine import machine_from_dict


def _ks_meta(**kwargs):
    return " ".join('%s="%s"' % item for item in kwargs.items())


class OrchestraLaunchMachine(LaunchMachine):
    """rchestra operation for launching an instance"""

    @inlineCallbacks
    def start_machine(self, machine_id, zookeepers):
        """Actually launch an instance with Orchestra.

        :param str machine_id: the juju machine ID to assign

        :param zookeepers: the machines currently running zookeeper, to which
            the new machine will need to connect
        :type zookeepers: list of
            :class:`juju.providers.orchestra.machine.OrchestraMachine`

        :return: a singe-entry list containing a
            :class:`juju.providers.orchestra.machine.OrchestraMachine`
            representing the newly-launched machine
        :rtype: :class:`twisted.internet.defer.Deferred`
        """
        cobbler = self._provider.cobbler
        instance_id = yield cobbler.acquire_system()

        cloud_init = self._create_cloud_init(machine_id, zookeepers)
        cloud_init.set_provider_type("orchestra")
        cloud_init.set_instance_id_accessor(instance_id)
        ks_meta = _ks_meta(MACHINE_ID=machine_id,
                           USER_DATA_BASE64=b64encode(cloud_init.render()))

        yield cobbler.set_on_system(instance_id, "ks_meta", ks_meta)
        yield cobbler.start_system(instance_id)
        (info,) = yield cobbler.describe_systems(instance_id)
        returnValue([machine_from_dict(info)])
