package testing_test

import (
	"labix.org/v2/mgo/bson"
	. "launchpad.net/gocheck"
	"launchpad.net/juju-core/testing"
	stdtesting "testing"
)

type mgoSuite struct {
	testing.LoggingSuite
	testing.MgoSuite
}

var _ = Suite(&mgoSuite{})

func TestMgoSuite(t *stdtesting.T) {
	testing.MgoTestPackage(t)
}

func (s *mgoSuite) SetUpSuite(c *C) {
	s.LoggingSuite.SetUpSuite(c)
	s.MgoSuite.SetUpSuite(c)
}

func (s *mgoSuite) TearDownSuite(c *C) {
	s.LoggingSuite.TearDownSuite(c)
	s.MgoSuite.TearDownSuite(c)
}

func (s *mgoSuite) SetUpTest(c *C) {
	s.LoggingSuite.SetUpTest(c)
	s.MgoSuite.SetUpTest(c)
}

func (s *mgoSuite) TearDownTest(c *C) {
	s.LoggingSuite.TearDownTest(c)
	s.MgoSuite.TearDownTest(c)
}

func (s *mgoSuite) TestMgoResetWhenUnauthorized(c *C) {
	session := testing.MgoDial()
	defer session.Close()
	err := session.DB("admin").AddUser("admin", "foo", false)
	if err != nil && err.Error() != "need to login" {
		c.Assert(err, IsNil)
	}
	// The test will fail if the reset does not succeed
}

func (s *mgoSuite) TestMgoStartAndClean(c *C) {
	c.Assert(testing.MgoAddr, Not(Equals), "")

	session := testing.MgoDial()
	defer session.Close()
	menu := session.DB("food").C("menu")
	err := menu.Insert(
		bson.D{{"spam", "lots"}},
		bson.D{{"eggs", "fried"}},
	)
	c.Assert(err, IsNil)
	food := make([]map[string]string, 0)
	err = menu.Find(nil).All(&food)
	c.Assert(err, IsNil)
	c.Assert(food, HasLen, 2)
	c.Assert(food[0]["spam"], Equals, "lots")
	c.Assert(food[1]["eggs"], Equals, "fried")

	testing.MgoReset()
	morefood := make([]map[string]string, 0)
	err = menu.Find(nil).All(&morefood)
	c.Assert(err, IsNil)
	c.Assert(morefood, HasLen, 0)
}
