/*
 * Copyright (C) 2007, 2008, 2009 Patrick Balleux, Nicolas Cardoso De Castro
 * (nicolas_cardoso@users.sourceforge.net), Daniel Žalar (danizmax@gmail.com)
 *
 * This file is part of JSymphonic program.
 *
 * JSymphonic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JSymphonic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JSymphonic. If not, see <http://www.gnu.org/licenses/>.
 *
 *****
 *
 * JSymphonicFirstConfig.java
 *
 * Created on 20 mai 2009, 11:10:47
 */

package org.danizmax.jsymphonic.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.naurd.media.jsymphonic.device.sony.nw.NWGeneric;

/**
 *
 * @author skiron
 */
public class JSymphonicFirstConfig extends javax.swing.JFrame {
/* FIELD */
    SettingsHandler sh;

/* CONSTRUCTOR */
    /**
     * Create a "first config" windows, asking the user what is the device generation and path.
     *
     * @param sh The instance of setting handler which needs to know the information.
     * @param devicePath The device path guessed so far, the user will have to check validity.
     */
    public JSymphonicFirstConfig(SettingsHandler sh, String devicePath) {
        // Save sh
        this.sh = sh;

        // Init component
        initComponents();
        // Set the path found so far to let the user check it
        devicePathTextField.setText(devicePath);
        // Set the generations in the combobox, add an entry for each generation available
        generationComboBox.removeAllItems();
        List<Integer> generationList = new ArrayList(NWGeneric.getGenerationMap().values());
        Collections.sort(generationList); // Sort element to display generation in ascending order
        Iterator it = generationList.iterator();
        while(it.hasNext()){
            generationComboBox.addItem(it.next());
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        applyButton = new javax.swing.JButton();
        configPanel = new javax.swing.JPanel();
        checkConfigLabel = new javax.swing.JLabel();
        pathLabel = new javax.swing.JLabel();
        devicePathTextField = new javax.swing.JTextField();
        generationLabel = new javax.swing.JLabel();
        generationComboBox = new javax.swing.JComboBox();
        jTextArea1 = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("localization/jsymphonicproperties"); // NOI18N
        setTitle(bundle.getString("JSymphonicProperties.configure_device")); // NOI18N

        applyButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/ok.png"))); // NOI18N
        java.util.ResourceBundle bundle1 = java.util.ResourceBundle.getBundle("localization/misc"); // NOI18N
        applyButton.setText(bundle1.getString("global.Apply")); // NOI18N
        applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyButtonActionPerformed(evt);
            }
        });

        checkConfigLabel.setFont(new java.awt.Font("Dialog", 0, 12)); // NOI18N
        checkConfigLabel.setText(bundle.getString("JSymphonicProperties.set_device")); // NOI18N

        pathLabel.setText(bundle.getString("JSymphonicProperties.devPathLabel.text")); // NOI18N

        devicePathTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                devicePathTextFieldActionPerformed(evt);
            }
        });

        generationLabel.setText(bundle.getString("JSymphonicProperties.genPathLabel.text")); // NOI18N

        generationComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Generation 5" }));

        jTextArea1.setBackground(getBackground());
        jTextArea1.setColumns(40);
        jTextArea1.setFont(new java.awt.Font("Dialog", 2, 12)); // NOI18N
        jTextArea1.setRows(2);
        jTextArea1.setText(bundle.getString("JSymphonicProperties.configure_device_note")); // NOI18N

        org.jdesktop.layout.GroupLayout configPanelLayout = new org.jdesktop.layout.GroupLayout(configPanel);
        configPanel.setLayout(configPanelLayout);
        configPanelLayout.setHorizontalGroup(
            configPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(configPanelLayout.createSequentialGroup()
                .add(configPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(checkConfigLabel)
                    .add(configPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(pathLabel))
                    .add(configPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(devicePathTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 446, Short.MAX_VALUE))
                    .add(configPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(generationLabel))
                    .add(configPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(generationComboBox, 0, 446, Short.MAX_VALUE)))
                .addContainerGap())
            .add(jTextArea1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 470, Short.MAX_VALUE)
        );
        configPanelLayout.setVerticalGroup(
            configPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(configPanelLayout.createSequentialGroup()
                .add(checkConfigLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pathLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(devicePathTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(generationLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(generationComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(jTextArea1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, configPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(applyButton))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(configPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(applyButton)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void devicePathTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_devicePathTextFieldActionPerformed
        
    }//GEN-LAST:event_devicePathTextFieldActionPerformed

    private void applyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_applyButtonActionPerformed
        // On click, save the generation and the device path in the sh instance
        sh.setDevicePath(devicePathTextField.getText());
        sh.setGeneration(NWGeneric.getKeyfromGenerationCombo((String)generationComboBox.getSelectedItem()));

        // Wake the sh instance to let it continue its task
        synchronized (this) {
            this.notifyAll();
        }
        this.dispose();
    }//GEN-LAST:event_applyButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton applyButton;
    private javax.swing.JLabel checkConfigLabel;
    private javax.swing.JPanel configPanel;
    private javax.swing.JTextField devicePathTextField;
    private javax.swing.JComboBox generationComboBox;
    private javax.swing.JLabel generationLabel;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JLabel pathLabel;
    // End of variables declaration//GEN-END:variables

}
