/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import java.util.Iterator;
import java.util.Stack;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeUtils {
    NodeUtils() {
    }

    public static int getAttributeValue(Node node, String attributeName, int defaultValue) {
        NamedNodeMap nnm = node.getAttributes();
        Node attribute = nnm.getNamedItem(attributeName);
        if (attribute == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attribute.getNodeValue());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String getNodeAttribute(Node node, String attributeName) {
        return NodeUtils.getNodeAttribute(node, attributeName, "");
    }

    public static String getNodeAttribute(Node node, String attributeName, String defaultValue) {
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        return attribute == null ? defaultValue : attribute.getNodeValue();
    }

    static boolean isNodeAttributePresent(Node node, String attributeName) {
        return node.getAttributes().getNamedItem(attributeName) != null;
    }

    public static String asText(NodeList rootNodes) {
        final StringBuffer sb = new StringBuffer(2048);
        NodeAction action = new NodeAction(){

            public boolean processElement(PreOrderTraversal traversal, Element node) {
                if (node.getNodeName().equalsIgnoreCase("p")) {
                    sb.append("\n");
                } else if (node.getNodeName().equalsIgnoreCase("tr")) {
                    sb.append("\n");
                } else if (node.getNodeName().equalsIgnoreCase("td")) {
                    sb.append(" | ");
                } else if (node.getNodeName().equalsIgnoreCase("th")) {
                    sb.append(" | ");
                } else if (node.getNodeName().equalsIgnoreCase("img") && HttpUnitOptions.getImagesTreatedAsAltText()) {
                    sb.append(NodeUtils.getNodeAttribute(node, "alt"));
                }
                return true;
            }

            public void processTextNodeValue(String value) {
                sb.append(HTMLParserFactory.getHTMLParser().getCleanedText(value));
            }
        };
        new PreOrderTraversal(rootNodes).perform(action);
        return sb.toString();
    }

    static class PreOrderTraversal {
        private Stack _pendingNodes = new Stack();
        private Stack _traversalContext = new Stack();
        private static final Object POP_CONTEXT = new Object();

        public PreOrderTraversal(NodeList rootNodes) {
            this.pushNodeList(rootNodes);
        }

        public PreOrderTraversal(Node rootNode) {
            this.pushNodeList(rootNode.getLastChild());
        }

        public void pushBaseContext(Object context) {
            this._traversalContext.push(context);
        }

        public void pushContext(Object context) {
            this._traversalContext.push(context);
            this._pendingNodes.push(POP_CONTEXT);
        }

        public Iterator getContexts() {
            return this._traversalContext.iterator();
        }

        public Object getClosestContext(Class matchingClass) {
            int i = this._traversalContext.size() - 1;
            while (i >= 0) {
                Object o = this._traversalContext.elementAt(i);
                if (matchingClass.isInstance(o)) {
                    return o;
                }
                --i;
            }
            return null;
        }

        public void perform(NodeAction action) {
            while (!this._pendingNodes.empty()) {
                Object object = this._pendingNodes.pop();
                if (object == POP_CONTEXT) {
                    this._traversalContext.pop();
                    continue;
                }
                Node node = (Node)object;
                if (node.getNodeType() == 3) {
                    action.processTextNodeValue(node.getNodeValue());
                } else {
                    if (node.getNodeType() != 1) continue;
                    action.processElement(this, (Element)node);
                }
                this.pushNodeList(node.getLastChild());
            }
        }

        private void pushNodeList(NodeList nl) {
            if (nl != null) {
                int i = nl.getLength() - 1;
                while (i >= 0) {
                    this._pendingNodes.push(nl.item(i));
                    --i;
                }
            }
        }

        private void pushNodeList(Node lastChild) {
            Node node = lastChild;
            while (node != null) {
                this._pendingNodes.push(node);
                node = node.getPreviousSibling();
            }
        }
    }

    static interface NodeAction {
        public boolean processElement(PreOrderTraversal var1, Element var2);

        public void processTextNodeValue(String var1);
    }
}

