/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit;

import com.meterware.httpunit.Button;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebClientListener;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;
import com.meterware.httpunit.WebWindow;
import com.meterware.httpunit.cookies.CookieJar;
import com.meterware.httpunit.cookies.CookieSource;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.jwebunit.LinkImagePredicate;
import net.sourceforge.jwebunit.TestContext;
import net.sourceforge.jwebunit.TextAndElementWalker;
import net.sourceforge.jwebunit.UnableToSetFormException;
import net.sourceforge.jwebunit.util.ExceptionUtility;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class HttpUnitDialog {
    private WebClient wc;
    private WebResponse resp;
    private TestContext context;
    private WebForm form;
    private Map multiselectMap = new HashMap();

    public HttpUnitDialog(String initialURL, TestContext context) {
        this.context = context;
        this.initWebClient();
        try {
            this.resp = this.wc.getResponse((WebRequest)new GetMethodWebRequest(initialURL));
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    private void initWebClient() {
        this.wc = this.context != null ? this.context.getWebClient() : new WebConversation();
        this.wc.addClientListener(new WebClientListener(){

            public void requestSent(WebClient webClient, WebRequest webRequest) {
            }

            public void responseReceived(WebClient webClient, WebResponse webResponse) {
                HttpUnitDialog.this.resp = webClient.getCurrentPage();
                HttpUnitDialog.this.form = null;
                HttpUnitDialog.this.multiselectMap.clear();
            }
        });
    }

    public WebWindow getWindow(String windowName) {
        return this.wc.getOpenWindow(windowName);
    }

    public WebClient getWebClient() {
        return this.wc;
    }

    public WebResponse getResponse() {
        return this.resp;
    }

    public String getResponseText() {
        try {
            return this.context.toEncodedString(this.resp.getText());
        }
        catch (IOException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public String getResponsePageTitle() {
        try {
            return this.context.toEncodedString(this.resp.getTitle());
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    private CookieJar getCookies() {
        return this.getResponse() != null ? new CookieJar((CookieSource)this.getResponse()) : null;
    }

    public boolean hasCookie(String cookieName) {
        CookieJar respJar = this.getCookies();
        String[] cookieNames = respJar.getCookieNames();
        for (int i = 0; i < cookieNames.length; ++i) {
            if (!cookieNames[i].equals(cookieName)) continue;
            return true;
        }
        return false;
    }

    public String getCookieValue(String cookieName) {
        return this.getCookies().getCookieValue(cookieName);
    }

    public WebForm getForm() {
        if (this.form == null && this.hasForm()) {
            this.setWorkingForm(this.getForm(0));
        }
        return this.form;
    }

    private WebForm getForm(int formIndex) {
        try {
            return this.resp.getForms()[formIndex];
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    private WebForm getForm(String nameOrID) {
        try {
            WebForm f = this.resp.getFormWithID(nameOrID);
            return f != null ? f : this.resp.getFormWithName(nameOrID);
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    private WebForm getFormWithButton(String buttonName) {
        if (this.hasForm()) {
            for (int i = 0; i < this.getForms().length; ++i) {
                WebForm webForm = this.getForms()[i];
                if (webForm.getSubmitButton(buttonName) == null) continue;
                return webForm;
            }
        }
        return null;
    }

    private WebForm getFormWithParameter(String paramName) {
        if (this.hasForm()) {
            for (int i = 0; i < this.getForms().length; ++i) {
                WebForm webForm = this.getForms()[i];
                String[] names = webForm.getParameterNames();
                for (int j = 0; j < names.length; ++j) {
                    if (!names[j].equals(paramName)) continue;
                    return webForm;
                }
            }
        }
        return null;
    }

    private WebForm[] getForms() {
        try {
            return this.resp.getForms();
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    private void checkFormStateWithParameter(String paramName) {
        if (this.form == null) {
            try {
                this.setWorkingForm(this.getFormWithParameter(paramName));
            }
            catch (UnableToSetFormException e) {
                throw new UnableToSetFormException("Unable to set form based on parameter [" + paramName + "].");
            }
        }
    }

    private void checkFormStateWithButton(String buttonName) {
        if (this.form == null) {
            this.setWorkingForm(this.getFormWithButton(buttonName));
        }
    }

    public void setWorkingForm(String nameOrId) {
        this.setWorkingForm(this.getForm(nameOrId));
    }

    private void setWorkingForm(WebForm newForm) {
        if (newForm == null) {
            throw new UnableToSetFormException("Attempted to set form to null.");
        }
        this.form = newForm;
    }

    public boolean hasForm() {
        try {
            return this.resp.getForms().length > 0;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hasForm(String nameOrID) {
        return this.getForm(nameOrID) != null;
    }

    public boolean hasFormParameterNamed(String paramName) {
        try {
            this.checkFormStateWithParameter(paramName);
        }
        catch (UnableToSetFormException e) {
            return false;
        }
        return this.getForm().hasParameterNamed(paramName);
    }

    public void setFormParameter(String paramName, String paramValue) {
        this.checkFormStateWithParameter(paramName);
        this.getForm().setParameter(paramName, paramValue);
    }

    public void updateFormParameter(String paramName, String paramValue) {
        List values;
        this.checkFormStateWithParameter(paramName);
        if (!this.multiselectMap.containsKey(paramName)) {
            this.multiselectMap.put(paramName, new ArrayList());
        }
        if (!(values = (List)this.multiselectMap.get(paramName)).contains(paramValue)) {
            values.add(paramValue);
        }
        this.getForm().setParameter(paramName, values.toArray(new String[0]));
    }

    public String getFormParameterValue(String paramName) {
        this.checkFormStateWithParameter(paramName);
        return this.getForm().getParameterValue(paramName);
    }

    public void removeFormParameter(String paramName) {
        this.checkFormStateWithParameter(paramName);
        this.getForm().removeParameter(paramName);
    }

    public void removeFormParameterWithValue(String paramName, String value) {
        this.checkFormStateWithParameter(paramName);
        if (this.multiselectMap.containsKey(paramName)) {
            List values = (List)this.multiselectMap.get(paramName);
            values.remove(value);
            this.getForm().setParameter(paramName, values.toArray(new String[0]));
        }
    }

    public boolean hasFormParameterLabeled(String paramLabel) {
        return null != this.getFormElementNameForLabel(paramLabel);
    }

    public String getFormElementNameForLabel(String formElementLabel) {
        try {
            Document document = this.getResponse().getDOM();
            Element root = document.getDocumentElement();
            NodeList forms = root.getElementsByTagName("form");
            for (int i = 0; i < forms.getLength(); ++i) {
                Element form = (Element)forms.item(i);
                TextAndElementWalker walker = new TextAndElementWalker(form, new String[]{"input", "select", "textarea"});
                Element formElement = walker.getElementAfterText(formElementLabel);
                if (formElement == null) continue;
                return formElement.getAttribute("name");
            }
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SubmitButton getSubmitButton(String buttonName) {
        this.checkFormStateWithButton(buttonName);
        return this.getForm().getSubmitButton(buttonName);
    }

    public String getSubmitButtonValue(String buttonName) {
        return this.getSubmitButton(buttonName).getValue().trim();
    }

    public boolean hasSubmitButton(String buttonName) {
        try {
            return this.getSubmitButton(buttonName) != null;
        }
        catch (UnableToSetFormException e) {
            return false;
        }
    }

    public Button getButton(String buttonId) {
        return this.getForm().getButtonWithID(buttonId);
    }

    public boolean hasButton(String buttonId) {
        try {
            return this.getButton(buttonId) != null;
        }
        catch (UnableToSetFormException e) {
            return false;
        }
    }

    public boolean isTextInResponse(String text) {
        try {
            return this.context.toEncodedString(this.resp.getText()).indexOf(text) >= 0;
        }
        catch (IOException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public boolean isTextInTable(String tableSummaryOrId, String text) {
        WebTable table = this.getWebTableBySummaryOrId(tableSummaryOrId);
        if (table == null) {
            throw new RuntimeException("No table with summary or id [" + tableSummaryOrId + "] found in response.");
        }
        for (int row = 0; row < table.getRowCount(); ++row) {
            for (int col = 0; col < table.getColumnCount(); ++col) {
                String cellHtml;
                TableCell cell = table.getTableCell(row, col);
                if (cell == null || (cellHtml = this.getNodeHtml(cell.getDOM())).indexOf(text) == -1) continue;
                return true;
            }
        }
        return false;
    }

    private String getNodeHtml(Node node) {
        String nodeHtml = "";
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                nodeHtml = nodeHtml + "<" + child.getNodeName() + ">";
            }
            nodeHtml = child.hasChildNodes() ? nodeHtml + this.getNodeHtml(child) : nodeHtml + child.getNodeValue();
            if (child.getNodeType() != 1) continue;
            nodeHtml = nodeHtml + "</" + child.getNodeName() + ">";
        }
        return this.context.toEncodedString(nodeHtml);
    }

    private static String getNodeText(Node node) {
        String nodeText = "";
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.hasChildNodes()) {
                nodeText = nodeText + HttpUnitDialog.getNodeText(child);
                continue;
            }
            if (child.getNodeType() != 3) continue;
            nodeText = nodeText + ((Text)child).getData();
        }
        return nodeText;
    }

    public WebTable getWebTableBySummaryOrId(String tableSummaryOrId) {
        WebTable table;
        try {
            table = this.resp.getTableWithSummary(tableSummaryOrId);
            if (table == null) {
                table = this.resp.getTableWithID(tableSummaryOrId);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        return table;
    }

    public String[][] getSparseTableBySummaryOrId(String tableSummaryOrId) {
        WebTable table = this.getWebTableBySummaryOrId(tableSummaryOrId);
        table.purgeEmptyCells();
        String[][] sparseTableCellValues = table.asText();
        return sparseTableCellValues;
    }

    public void submit() {
        try {
            this.resp = this.getForm().submit();
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public void submit(String buttonName) {
        try {
            this.getForm().getSubmitButton(buttonName).click();
            this.resp = this.wc.getCurrentPage();
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public void reset() {
        this.getForm().reset();
    }

    private void submitRequest(WebLink aLink) {
        try {
            aLink.click();
            this.resp = this.wc.getCurrentPage();
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public boolean isLinkPresentWithText(String linkText) {
        try {
            return this.resp.getLinkWith(linkText) != null;
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public boolean isLinkPresentWithText(String linkText, int index) {
        return this.getLinkWithText(linkText, index) != null;
    }

    public boolean isLinkPresentWithImage(String imageFileName) {
        try {
            return this.resp.getFirstMatchingLink((HTMLElementPredicate)new LinkImagePredicate(), (Object)imageFileName) != null;
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public boolean isLinkPresent(String anId) {
        try {
            return this.resp.getLinkWithID(anId) != null;
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public void clickLinkWithText(String linkText) {
        WebLink link = null;
        try {
            link = this.resp.getLinkWith(linkText);
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
        if (link == null) {
            throw new RuntimeException("No Link found for \"" + linkText + "\"");
        }
        this.submitRequest(link);
    }

    public void clickLinkWithText(String linkText, int index) {
        WebLink link = this.getLinkWithText(linkText, index);
        if (link == null) {
            throw new RuntimeException("No Link found for \"" + linkText + "\" with index " + index);
        }
        this.submitRequest(link);
    }

    private WebLink getLinkWithText(String linkText, int index) {
        WebLink link = null;
        try {
            WebLink[] links = this.resp.getLinks();
            int count = 0;
            for (int i = 0; i < links.length; ++i) {
                Node node = links[i].getDOMSubtree();
                if (!HttpUnitDialog.nodeContainsText(node, linkText)) continue;
                if (count == index) {
                    link = links[i];
                    break;
                }
                ++count;
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
        return link;
    }

    public static boolean nodeContainsText(Node node, String linkText) {
        return HttpUnitDialog.getNodeText(node).indexOf(linkText) != -1;
    }

    public void clickLinkWithTextAfterText(String linkText, String labelText) {
        WebLink link = this.getLinkWithTextAfterText(linkText, labelText);
        if (link == null) {
            throw new RuntimeException("No Link found for \"" + linkText + "\" with label \"" + labelText + "\"");
        }
        this.submitRequest(link);
    }

    private WebLink getLinkWithTextAfterText(String linkText, String labelText) {
        try {
            TextAndElementWalker walker = new TextAndElementWalker(this.resp.getDOM().getDocumentElement(), new String[]{"a"});
            Element linkElement = walker.getElementWithTextAfterText(linkText, labelText);
            if (linkElement != null) {
                return this.resp.getFirstMatchingLink((HTMLElementPredicate)new SameLinkPredicate(), (Object)linkElement);
            }
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
        return null;
    }

    public void clickLink(String anID) {
        WebLink link = null;
        try {
            link = this.resp.getLinkWithID(anID);
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
        if (link == null) {
            throw new RuntimeException("No Link found with ID \"" + anID + "\"");
        }
        this.submitRequest(link);
    }

    public void clickLinkWithImage(String imageFileName) {
        WebLink link = null;
        try {
            link = this.resp.getFirstMatchingLink((HTMLElementPredicate)new LinkImagePredicate(), (Object)imageFileName);
        }
        catch (SAXException e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
        if (link == null) {
            throw new RuntimeException("No Link found with imageFileName \"" + imageFileName + "\"");
        }
        this.submitRequest(link);
    }

    public void clickButton(String buttonId) {
        try {
            this.getButton(buttonId).click();
            this.resp = this.wc.getCurrentPage();
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public boolean hasRadioOption(String radioGroup, String radioOption) {
        WebForm[] forms = this.getForms();
        for (int i = 0; i < forms.length; ++i) {
            WebForm form = forms[i];
            String[] opts = form.getOptionValues(radioGroup);
            for (int j = 0; j < opts.length; ++j) {
                String opt = opts[j];
                if (!radioOption.equals(opt)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getOptionsFor(String selectName) {
        return this.getForm().getOptions(selectName);
    }

    public String[] getOptionValuesFor(String selectName) {
        return this.getForm().getOptionValues(selectName);
    }

    public String getSelectedOption(String selectName) {
        String val = this.getFormParameterValue(selectName);
        String[] vals = this.getOptionValuesFor(selectName);
        for (int i = 0; i < vals.length; ++i) {
            if (!vals[i].equals(val)) continue;
            return this.getOptionsFor(selectName)[i];
        }
        return null;
    }

    public String getValueForOption(String selectName, String option) {
        String[] opts = this.getOptionsFor(selectName);
        for (int i = 0; i < opts.length; ++i) {
            if (!opts[i].equals(option)) continue;
            return this.getOptionValuesFor(selectName)[i];
        }
        throw new RuntimeException("Unable to find option " + option + " for " + selectName);
    }

    public void selectOption(String selectName, String option) {
        this.setFormParameter(selectName, this.getValueForOption(selectName, option));
    }

    public Element getElement(String anID) {
        try {
            return this.walkDOM(this.getResponse().getDOM().getDocumentElement(), anID);
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    private Element walkDOM(Element element, String anID) {
        if (element.getAttribute("id").equals(anID) || element.getAttribute("ID").equals(anID)) {
            return element;
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element el;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (el = this.walkDOM((Element)child, anID)) == null) continue;
            return el;
        }
        return null;
    }

    public boolean isTextInElement(Element element, String text) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3 && ((Text)child).getData().indexOf(text) != -1) {
                return true;
            }
            if (child.getNodeType() != 1 || !this.isTextInElement((Element)child, text)) continue;
            return true;
        }
        return false;
    }

    public void gotoWindow(String windowName) {
        this.setMainWindow(this.getWindow(windowName));
    }

    public void gotoRootWindow() {
        this.setMainWindow(this.wc.getOpenWindows()[0]);
    }

    private void setMainWindow(WebWindow win) {
        this.wc.setMainWindow(win);
        this.resp = this.wc.getMainWindow().getCurrentPage();
    }

    public void gotoFrame(String frameName) {
        this.resp = this.getFrame(frameName);
        this.form = null;
    }

    public WebResponse getFrame(String frameName) {
        return this.wc.getMainWindow().getFrameContents(frameName);
    }

    public void gotoPage(String url) {
        try {
            this.resp = this.wc.getResponse(url);
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString(e));
        }
    }

    public void dumpCookies(PrintStream stream) {
        CookieJar respJar = this.getCookies();
        String[] cookieNames = respJar.getCookieNames();
        for (int i = 0; i < cookieNames.length; ++i) {
            stream.print(cookieNames[i] + " :  [" + respJar.getCookieValue(cookieNames[i]) + "]\n");
        }
    }

    public void dumpResponse() {
        this.dumpResponse(System.out);
    }

    public void dumpResponse(PrintStream stream) {
        try {
            stream.println(this.getResponseText());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void dumpTable(String tableNameOrId, PrintStream stream) {
        this.dumpTable(tableNameOrId, this.getSparseTableBySummaryOrId(tableNameOrId), stream);
    }

    public void dumpTable(String tableNameOrId, String[][] table) {
        this.dumpTable(tableNameOrId, table, System.out);
    }

    public void dumpTable(String tableNameOrId, String[][] table, PrintStream stream) {
        stream.print("\n" + tableNameOrId + ":");
        for (int i = 0; i < table.length; ++i) {
            String[] cell = table[i];
            stream.print("\n\t");
            for (int j = 0; j < cell.length; ++j) {
                stream.print("[" + cell[j] + "]");
            }
        }
    }

    private static class SameLinkPredicate
    implements HTMLElementPredicate {
        private SameLinkPredicate() {
        }

        public boolean matchesCriteria(Object found, Object given) {
            WebLink link = (WebLink)found;
            Element foundElement = (Element)link.getDOMSubtree();
            Element givenElement = (Element)given;
            NamedNodeMap foundAttributes = foundElement.getAttributes();
            NamedNodeMap givenAttributes = givenElement.getAttributes();
            if (foundAttributes.getLength() != givenAttributes.getLength()) {
                return false;
            }
            for (int i = 0; i < foundAttributes.getLength(); ++i) {
                Attr foundAttribute = (Attr)foundAttributes.item(i);
                Attr givenAttribute = (Attr)givenAttributes.getNamedItem(foundAttribute.getName());
                if (foundAttribute.getValue().equals(givenAttribute.getValue())) continue;
                return false;
            }
            return true;
        }
    }
}

